/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.undefined;

import com.ait.lienzo.client.core.event.NodeMouseEnterHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.EventPropagationMode;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.ExpressionEditorTooltip;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.BaseGridColumnRenderer;

public class UndefinedExpressionColumnRenderer
extends BaseGridColumnRenderer<String>
implements HasDOMElementResources {
    private final ExpressionEditorTooltip tooltip = this.getTooltip();
    private final Group editorTypesContainer = (Group)GWT.create(Group.class);
    private final Set<HandlerRegistration> tooltipEventHandlerRegistrations = new HashSet<HandlerRegistration>();
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final UndefinedExpressionGrid gridWidget;

    public UndefinedExpressionColumnRenderer(Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, UndefinedExpressionGrid gridWidget) {
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.gridWidget = gridWidget;
        this.setupTooltips();
    }

    ExpressionEditorTooltip getTooltip() {
        return ExpressionEditorTooltip.INSTANCE;
    }

    private void setupTooltips() {
        double x = 10.0;
        for (ExpressionEditorDefinition definition : this.expressionEditorDefinitionsSupplier.get()) {
            if (!definition.getModelClass().isPresent()) continue;
            Rectangle r = new Rectangle(10.0, 10.0);
            ((Rectangle)((Rectangle)((Rectangle)r.setY(10.0)).setX(x)).setFillColor((IColor)ColorName.AQUAMARINE)).setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
            this.tooltipEventHandlerRegistrations.add(r.addNodeMouseEnterHandler(this.getNodeMouseEnterHandler(definition, r)));
            this.tooltipEventHandlerRegistrations.add(r.addNodeMouseExitHandler(event -> this.tooltip.hide()));
            this.tooltipEventHandlerRegistrations.add(r.addNodeMouseClickHandler(event -> {
                this.tooltip.hide();
                this.gridWidget.onExpressionTypeChanged(definition.getType());
            }));
            x += 15.0;
            this.editorTypesContainer.add((IPrimitive)r);
        }
    }

    NodeMouseEnterHandler getNodeMouseEnterHandler(ExpressionEditorDefinition<Expression> definition, Rectangle r) {
        return event -> {
            Transform transform = this.editorTypesContainer.getViewport().getTransform();
            double tx = transform.getTranslateX();
            double ty = transform.getTranslateY();
            double absoluteCellX = this.editorTypesContainer.getAbsoluteLocation().getX() - tx;
            double absoluteCellY = this.editorTypesContainer.getAbsoluteLocation().getY() - ty;
            this.tooltip.show(definition, absoluteCellX, absoluteCellY, r);
        };
    }

    public Group renderCell(GridCell<String> cell, GridBodyCellRenderContext context) {
        this.gridWidget.getLayer().remove(this.tooltip.asPrimitive());
        this.gridWidget.getLayer().add(this.tooltip.asPrimitive());
        Group g = new Group();
        g.add((IPrimitive)this.editorTypesContainer);
        return g;
    }

    public void destroyResources() {
        this.tooltipEventHandlerRegistrations.stream().forEach(com.google.web.bindery.event.shared.HandlerRegistration::removeHandler);
        this.tooltipEventHandlerRegistrations.clear();
        this.tooltip.hide();
    }
}

