/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import com.ait.lienzo.client.core.event.INodeXYEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.enterprise.event.Event;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHeaderValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHeaderValueCommand;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderGridWidgetMouseDoubleClickHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.HasExpressionEditorControls;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public abstract class BaseExpressionGrid<E extends Expression, M extends BaseUIModelMapper<E>>
extends BaseGridWidget
implements HasExpressionEditorControls {
    protected final GridCellTuple parent;
    protected final HasExpression hasExpression;
    protected final Optional<E> expression;
    protected final Optional<HasName> hasName;
    protected final DMNGridPanel gridPanel;
    protected final DMNGridLayer gridLayer;
    protected final SessionManager sessionManager;
    protected final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected final Event<ExpressionEditorSelectedEvent> editorSelectedEvent;
    protected M uiModelMapper;

    public BaseExpressionGrid(GridCellTuple parent, HasExpression hasExpression, Optional<E> expression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, GridRenderer gridRenderer, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<ExpressionEditorSelectedEvent> editorSelectedEvent) {
        this(parent, hasExpression, expression, hasName, gridPanel, gridLayer, (GridData)new DMNGridData(gridLayer), gridRenderer, sessionManager, sessionCommandManager, editorSelectedEvent);
    }

    public BaseExpressionGrid(GridCellTuple parent, HasExpression hasExpression, Optional<E> expression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, GridData gridData, GridRenderer gridRenderer, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<ExpressionEditorSelectedEvent> editorSelectedEvent) {
        super(gridData, (GridSelectionManager)gridLayer, (GridPinnedModeManager)gridLayer, gridRenderer);
        this.gridPanel = gridPanel;
        this.gridLayer = gridLayer;
        this.parent = parent;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.editorSelectedEvent = editorSelectedEvent;
        this.hasExpression = hasExpression;
        this.expression = expression;
        this.hasName = hasName;
        this.doInitialisation();
    }

    protected void doInitialisation() {
        this.uiModelMapper = this.makeUiModelMapper();
        this.initialiseUiColumns();
        this.initialiseUiModel();
    }

    protected abstract M makeUiModelMapper();

    protected abstract void initialiseUiColumns();

    protected abstract void initialiseUiModel();

    protected Function<GridCellTuple, AbstractCanvasGraphCommand> newCellHasNoValueCommand() {
        return gc -> new DeleteCellValueCommand((GridCellTuple)gc, () -> this.uiModelMapper, () -> ((DMNGridLayer)this.gridLayer).batch());
    }

    protected Function<GridCellValueTuple, AbstractCanvasGraphCommand> newCellHasValueCommand() {
        return gcv -> new SetCellValueCommand((GridCellValueTuple)gcv, () -> this.uiModelMapper, () -> ((DMNGridLayer)this.gridLayer).batch());
    }

    protected Function<GridCellTuple, AbstractCanvasGraphCommand> newHeaderHasNoValueCommand() {
        return gc -> new DeleteHeaderValueCommand(this.extractEditableHeaderMetaData((GridCellTuple)gc), () -> ((DMNGridLayer)this.gridLayer).batch());
    }

    protected Function<GridCellValueTuple, AbstractCanvasGraphCommand> newHeaderHasValueCommand() {
        return gcv -> {
            String title = gcv.getValue().getValue().toString();
            return new SetHeaderValueCommand(title, this.extractEditableHeaderMetaData((GridCellTuple)gcv), () -> ((DMNGridLayer)this.gridLayer).batch());
        };
    }

    protected EditableHeaderMetaData extractEditableHeaderMetaData(GridCellTuple gc) {
        int headerRowIndex = gc.getRowIndex();
        int headerColumnIndex = gc.getColumnIndex();
        GridColumn.HeaderMetaData headerMetaData = (GridColumn.HeaderMetaData)((GridColumn)((BaseUIModelMapper)this.uiModelMapper).getUiModel().get().getColumns().get(headerColumnIndex)).getHeaderMetaData().get(headerRowIndex);
        if (headerMetaData instanceof EditableHeaderMetaData) {
            return (EditableHeaderMetaData)headerMetaData;
        }
        throw new IllegalArgumentException("Header (" + headerColumnIndex + ", " + headerRowIndex + ") was not an instanceof EditableHeaderMetaData");
    }

    protected NodeMouseDoubleClickHandler getGridMouseDoubleClickHandler(GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager) {
        return new EditableHeaderGridWidgetMouseDoubleClickHandler((GridWidget)this, selectionManager, pinnedModeManager, this.renderer);
    }

    public boolean onDragHandle(INodeXYEvent event) {
        return false;
    }

    public Viewport getViewport() {
        Viewport viewport = super.getViewport();
        if (viewport == null) {
            viewport = this.gridLayer.getViewport();
        }
        return viewport;
    }

    public Layer getLayer() {
        Object layer = super.getLayer();
        if (layer == null) {
            layer = this.gridLayer;
        }
        return layer;
    }

    public void select() {
        this.editorSelectedEvent.fire((Object)new ExpressionEditorSelectedEvent(this.sessionManager.getCurrentSession(), Optional.of(this)));
        super.select();
    }

    public GridCellTuple getParentInformation() {
        return this.parent;
    }

    public Optional<E> getExpression() {
        return this.expression;
    }

    public double getMinimumWidth() {
        double minimumWidth = 0.0;
        int columnCount = this.model.getColumnCount();
        List uiColumns = this.model.getColumns();
        for (int columnIndex = 0; columnIndex < columnCount - 1; ++columnIndex) {
            GridColumn editorColumn = (GridColumn)uiColumns.get(columnIndex);
            minimumWidth += editorColumn.getWidth();
        }
        if (columnCount > 0) {
            minimumWidth += ((GridColumn)uiColumns.get(columnCount - 1)).getMinimumWidth().doubleValue();
        }
        return minimumWidth;
    }
}

