/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.types.Point2D;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderUtilities;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetMouseDoubleClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class EditableHeaderGridWidgetMouseDoubleClickHandler
extends BaseGridWidgetMouseDoubleClickHandler {
    public EditableHeaderGridWidgetMouseDoubleClickHandler(GridWidget gridWidget, GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager, GridRenderer renderer) {
        super(gridWidget, selectionManager, pinnedModeManager, renderer);
    }

    protected boolean handleHeaderCellDoubleClick(NodeMouseDoubleClickEvent event) {
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this.gridWidget, (Point2D)new Point2D((double)event.getX(), (double)event.getY()));
        double cx = ap.getX();
        double cy = ap.getY();
        BaseGridRendererHelper rendererHelper = this.gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
        if (ri == null) {
            return false;
        }
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(cx);
        GridColumn column = ci.getColumn();
        if (!this.hasEditableHeader(column)) {
            return false;
        }
        Integer uiHeaderRowIndex = EditableHeaderUtilities.getUiHeaderRowIndex(this.gridWidget, column, cy);
        if (!this.isEditableHeader(column, uiHeaderRowIndex)) {
            return false;
        }
        EditableHeaderMetaData headerMetaData = (EditableHeaderMetaData)((Object)column.getHeaderMetaData().get(uiHeaderRowIndex));
        GridBodyCellRenderContext context = EditableHeaderUtilities.makeRenderContext(this.gridWidget, ri, ci, uiHeaderRowIndex);
        headerMetaData.edit(context);
        return true;
    }

    private boolean hasEditableHeader(GridColumn<?> column) {
        if (column == null) {
            return false;
        }
        return column.getHeaderMetaData().stream().anyMatch(md -> md instanceof EditableHeaderMetaData);
    }

    private boolean isEditableHeader(GridColumn<?> column, Integer uiHeaderRowIndex) {
        if (column == null) {
            return false;
        }
        if (uiHeaderRowIndex == null) {
            return false;
        }
        return column.getHeaderMetaData().get(uiHeaderRowIndex) instanceof EditableHeaderMetaData;
    }
}

