/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumn;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class AddOutputClauseCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final DecisionTable dtable;
    private final OutputClause outputClause;
    private final GridData uiModel;
    private final Supplier<OutputClauseColumn> uiModelColumnSupplier;
    private final int uiColumnIndex;
    private final DecisionTableUIModelMapper uiModelMapper;
    private final Command executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final String name;
    private Optional<OutputClauseColumn> uiModelColumn = Optional.empty();

    public AddOutputClauseCommand(DecisionTable dtable, OutputClause outputClause, GridData uiModel, Supplier<OutputClauseColumn> uiModelColumnSupplier, int uiColumnIndex, DecisionTableUIModelMapper uiModelMapper, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.dtable = dtable;
        this.outputClause = outputClause;
        this.uiModel = uiModel;
        this.uiModelColumnSupplier = uiModelColumnSupplier;
        this.uiColumnIndex = uiColumnIndex;
        this.uiModelMapper = uiModelMapper;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.name = DecisionTableDefaultValueUtilities.getNewOutputClauseName(dtable);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                AddOutputClauseCommand.this.dtable.getComponentWidths().add(AddOutputClauseCommand.this.uiColumnIndex, null);
                int clauseIndex = AddOutputClauseCommand.this.uiColumnIndex - 1 - AddOutputClauseCommand.this.dtable.getInput().size();
                AddOutputClauseCommand.this.dtable.getOutput().add(clauseIndex, AddOutputClauseCommand.this.outputClause);
                AddOutputClauseCommand.this.outputClause.setName(AddOutputClauseCommand.this.name);
                AddOutputClauseCommand.this.dtable.getRule().forEach(rule -> {
                    LiteralExpression le = new LiteralExpression();
                    le.getText().setValue("");
                    rule.getOutputEntry().add(clauseIndex, le);
                    le.setParent((DMNModelInstrumentedBase)rule);
                });
                AddOutputClauseCommand.this.outputClause.setParent((DMNModelInstrumentedBase)AddOutputClauseCommand.this.dtable);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                AddOutputClauseCommand.this.dtable.getComponentWidths().remove(AddOutputClauseCommand.this.uiColumnIndex);
                int clauseIndex = AddOutputClauseCommand.this.dtable.getOutput().indexOf(AddOutputClauseCommand.this.outputClause);
                AddOutputClauseCommand.this.dtable.getRule().forEach(rule -> rule.getOutputEntry().remove(clauseIndex));
                AddOutputClauseCommand.this.dtable.getOutput().remove(AddOutputClauseCommand.this.outputClause);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                if (!AddOutputClauseCommand.this.uiModelColumn.isPresent()) {
                    AddOutputClauseCommand.this.uiModelColumn = Optional.of((OutputClauseColumn)((Object)AddOutputClauseCommand.this.uiModelColumnSupplier.get()));
                }
                AddOutputClauseCommand.this.uiModel.insertColumn(AddOutputClauseCommand.this.uiColumnIndex, (GridColumn)AddOutputClauseCommand.this.uiModelColumn.get());
                for (int rowIndex = 0; rowIndex < AddOutputClauseCommand.this.dtable.getRule().size(); ++rowIndex) {
                    AddOutputClauseCommand.this.uiModelMapper.fromDMNModel(rowIndex, AddOutputClauseCommand.this.uiColumnIndex);
                }
                AddOutputClauseCommand.this.updateParentInformation();
                AddOutputClauseCommand.this.executeCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                AddOutputClauseCommand.this.uiModelColumn.ifPresent(arg_0 -> ((GridData)AddOutputClauseCommand.this.uiModel).deleteColumn(arg_0));
                AddOutputClauseCommand.this.updateParentInformation();
                AddOutputClauseCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

