/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.canvas;

import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.client.commands.factory.graph.DMNDeleteConnectorCommand;
import org.kie.workbench.common.dmn.client.commands.factory.graph.DMNDeregisterNodeCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNGraphsProvider;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeregisterNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.NodeDefinitionHelper;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public class DMNSafeDeleteNodeCommand
extends SafeDeleteNodeCommand {
    private final DMNGraphsProvider graphsProvider;
    private final Node<?, Edge> node;

    public DMNSafeDeleteNodeCommand(Node<?, Edge> node, SafeDeleteNodeCommand.SafeDeleteNodeCommandCallback safeDeleteCallback, SafeDeleteNodeCommand.Options options, DMNGraphsProvider graphsProvider) {
        super(node, safeDeleteCallback, options);
        this.graphsProvider = graphsProvider;
        this.node = node;
    }

    public boolean shouldKeepChildren(Node<Definition<?>, Edge> candidate) {
        return DefinitionUtils.getElementDefinition(candidate) instanceof DecisionService;
    }

    public GraphsProvider getGraphsProvider() {
        return this.graphsProvider;
    }

    protected Graph<?, Node> getGraph(GraphCommandExecutionContext context) {
        return this.getGraph(this.node);
    }

    Graph getGraph(Node node) {
        String diagramId = NodeDefinitionHelper.getDiagramId((Node)node);
        Diagram diagram = this.graphsProvider.getDiagram(diagramId);
        return diagram.getGraph();
    }

    protected Node<?, Edge> getNode(GraphCommandExecutionContext context, String uuid) {
        return this.node;
    }

    protected DeregisterNodeCommand createDeregisterNodeCommand(Node node) {
        return new DMNDeregisterNodeCommand(this.getGraph(node), node.getUUID());
    }

    protected DeleteConnectorCommand getDeleteConnectorCommand(Edge<? extends View<?>, Node> edge) {
        return new DMNDeleteConnectorCommand(edge, this.graphsProvider);
    }
}

