/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.common;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasFocusedShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;

@ApplicationScoped
public class CanvasFocusUtils {
    private final DMNGraphUtils dmnGraphUtils;
    private final Event<CanvasFocusedShapeEvent> canvasFocusedSelectionEvent;
    private final Event<CanvasSelectionEvent> canvasSelectionEvent;

    @Inject
    public CanvasFocusUtils(DMNGraphUtils dmnGraphUtils, Event<CanvasFocusedShapeEvent> canvasFocusedSelectionEvent, Event<CanvasSelectionEvent> canvasSelectionEvent) {
        this.dmnGraphUtils = dmnGraphUtils;
        this.canvasFocusedSelectionEvent = canvasFocusedSelectionEvent;
        this.canvasSelectionEvent = canvasSelectionEvent;
    }

    public void focus(String nodeUUID) {
        CanvasHandler canvasHandler = this.dmnGraphUtils.getCanvasHandler();
        this.canvasSelectionEvent.fire((Object)this.makeCanvasSelectionEvent(canvasHandler, nodeUUID));
        this.canvasFocusedSelectionEvent.fire((Object)this.makeCanvasFocusedShapeEvent(canvasHandler, nodeUUID));
        if (canvasHandler != null && canvasHandler.getCanvas() != null) {
            canvasHandler.getCanvas().focus();
        }
    }

    CanvasSelectionEvent makeCanvasSelectionEvent(CanvasHandler canvas, String uuid) {
        return new CanvasSelectionEvent(canvas, uuid);
    }

    CanvasFocusedShapeEvent makeCanvasFocusedShapeEvent(CanvasHandler canvas, String uuid) {
        return new CanvasFocusedShapeEvent(canvas, uuid);
    }
}

