/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.drds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.appformer.client.stateControl.registry.Registry;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSessionState;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DRGDiagramUtils;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CurrentRegistryChangedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.LockRequiredEvent;

@ApplicationScoped
@Default
public class DMNDiagramsSession {
    private static Diagram NO_DIAGRAM = null;
    private ManagedInstance<DMNDiagramsSessionState> dmnDiagramsSessionStates;
    private SessionManager sessionManager;
    private DMNDiagramUtils dmnDiagramUtils;
    private Map<String, DMNDiagramsSessionState> dmnSessionStatesByPathURI = new HashMap<String, DMNDiagramsSessionState>();
    private Event<LockRequiredEvent> locker;
    private Map<String, List<Command<AbstractCanvasHandler, CanvasViolation>>> storedUndoHistories;
    private Map<String, List<Command<AbstractCanvasHandler, CanvasViolation>>> storedRedoHistories;
    private Event<CurrentRegistryChangedEvent> currentRegistryChangedEvent;

    public DMNDiagramsSession() {
    }

    @Inject
    public DMNDiagramsSession(ManagedInstance<DMNDiagramsSessionState> dmnDiagramsSessionStates, SessionManager sessionManager, DMNDiagramUtils dmnDiagramUtils, Event<LockRequiredEvent> locker, Event<CurrentRegistryChangedEvent> currentRegistryChangedEvent) {
        this.dmnDiagramsSessionStates = dmnDiagramsSessionStates;
        this.sessionManager = sessionManager;
        this.dmnDiagramUtils = dmnDiagramUtils;
        this.locker = locker;
        this.storedUndoHistories = new HashMap<String, List<Command<AbstractCanvasHandler, CanvasViolation>>>();
        this.storedRedoHistories = new HashMap<String, List<Command<AbstractCanvasHandler, CanvasViolation>>>();
        this.currentRegistryChangedEvent = currentRegistryChangedEvent;
    }

    public Map<String, List<Command<AbstractCanvasHandler, CanvasViolation>>> getStoredUndoHistories() {
        return this.storedUndoHistories;
    }

    public Map<String, List<Command<AbstractCanvasHandler, CanvasViolation>>> getStoredRedoHistories() {
        return this.storedRedoHistories;
    }

    public void destroyState(Metadata metadata) {
        this.dmnSessionStatesByPathURI.remove(this.getSessionKey(metadata));
    }

    public DMNDiagramsSessionState setState(Metadata metadata, Map<String, Diagram> diagramsByDiagramElementId, Map<String, DMNDiagramElement> dmnDiagramsByDiagramElementId) {
        DMNDiagramsSessionState state = (DMNDiagramsSessionState)this.dmnDiagramsSessionStates.get();
        state.getDiagramsByDiagramId().putAll(diagramsByDiagramElementId);
        state.getDMNDiagramsByDiagramId().putAll(dmnDiagramsByDiagramElementId);
        this.dmnSessionStatesByPathURI.put(this.getSessionKey(metadata), state);
        return state;
    }

    public boolean isSessionStatePresent() {
        return this.getSessionState() != null;
    }

    public DMNDiagramsSessionState getSessionState() {
        return this.dmnSessionStatesByPathURI.get(this.getCurrentSessionKey());
    }

    public String getCurrentSessionKey() {
        return Optional.ofNullable(this.getCurrentGraphDiagram()).map(diagram -> this.getSessionKey(diagram.getMetadata())).orElse("");
    }

    public String getSessionKey(Metadata metadata) {
        return Optional.ofNullable(metadata).map(Metadata::getPath).map(Path::toURI).orElse("");
    }

    public void add(DMNDiagramElement dmnDiagram, Diagram stunnerDiagram) {
        String diagramId = dmnDiagram.getId().getValue();
        this.getSessionState().getDiagramsByDiagramId().put(diagramId, stunnerDiagram);
        this.getSessionState().getDMNDiagramsByDiagramId().put(diagramId, dmnDiagram);
        this.locker.fire((Object)new LockRequiredEvent());
    }

    public void remove(DMNDiagramElement dmnDiagram) {
        String diagramId = dmnDiagram.getId().getValue();
        this.getSessionState().getDiagramsByDiagramId().remove(diagramId);
        this.getSessionState().getDMNDiagramsByDiagramId().remove(diagramId);
        this.locker.fire((Object)new LockRequiredEvent());
    }

    public Diagram getDiagram(String dmnDiagramElementId) {
        return this.getSessionState().getDiagram(dmnDiagramElementId);
    }

    public String getCurrentDiagramId() {
        Optional<DMNDiagramElement> current;
        if (!Objects.isNull(this.getSessionState()) && (current = this.getCurrentDMNDiagramElement()).isPresent()) {
            return current.get().getId().getValue();
        }
        return null;
    }

    public DMNDiagramElement getDMNDiagramElement(String dmnDiagramElementId) {
        return this.getSessionState().getDMNDiagramElement(dmnDiagramElementId);
    }

    public DMNDiagramTuple getDiagramTuple(String dmnDiagramElementId) {
        return this.getSessionState().getDiagramTuple(dmnDiagramElementId);
    }

    public List<DMNDiagramTuple> getDMNDiagrams() {
        return this.getSessionState().getDMNDiagrams();
    }

    public void onSessionDiagramOpenedEvent(@Observes SessionDiagramOpenedEvent sessionDiagramOpenedEvent) {
        this.loadHistoryForTheCurrentDiagram();
    }

    public void onDMNDiagramSelected(@Observes DMNDiagramSelected selected) {
        this.storeCurrentRegistryHistory();
        DMNDiagramElement selectedDiagramElement = selected.getDiagramElement();
        if (this.belongsToCurrentSessionState(selectedDiagramElement)) {
            this.getSessionState().setCurrentDMNDiagramElement(selectedDiagramElement);
        }
    }

    void loadHistoryForTheCurrentDiagram() {
        this.getCurrentSession().ifPresent(session -> {
            if (session instanceof EditorSession) {
                if (this.getStoredRedoHistories().containsKey(this.getCurrentDiagramId()) && this.getStoredUndoHistories().containsKey(this.getCurrentDiagramId())) {
                    Registry undoRegistry = ((EditorSession)session).getCommandRegistry();
                    List<Command<AbstractCanvasHandler, CanvasViolation>> undoHistory = this.getStoredUndoHistories().get(this.getCurrentDiagramId());
                    this.loadHistoryToTheRegistry(undoHistory, (Registry<Command<AbstractCanvasHandler, CanvasViolation>>)undoRegistry);
                    Registry redoRegistry = ((EditorSession)session).getRedoCommandRegistry();
                    List<Command<AbstractCanvasHandler, CanvasViolation>> redoHistory = this.getStoredRedoHistories().get(this.getCurrentDiagramId());
                    this.loadHistoryToTheRegistry(redoHistory, (Registry<Command<AbstractCanvasHandler, CanvasViolation>>)redoRegistry);
                } else {
                    ((EditorSession)session).getCommandRegistry().clear();
                    ((EditorSession)session).getRedoCommandRegistry().clear();
                }
                this.notifyRegistryChanged();
            }
        });
    }

    void loadHistoryToTheRegistry(List<Command<AbstractCanvasHandler, CanvasViolation>> history, Registry<Command<AbstractCanvasHandler, CanvasViolation>> registry) {
        registry.clear();
        for (Command<AbstractCanvasHandler, CanvasViolation> command : history) {
            registry.register(command);
        }
    }

    void storeCurrentRegistryHistory() {
        this.getCurrentSession().ifPresent(session -> {
            if (session instanceof EditorSession) {
                List history = ((EditorSession)session).getCommandRegistry().getHistory();
                this.getStoredUndoHistories().put(this.getCurrentDiagramId(), history);
                List redoHistory = ((EditorSession)session).getRedoCommandRegistry().getHistory();
                this.getStoredRedoHistories().put(this.getCurrentDiagramId(), redoHistory);
            }
        });
    }

    public boolean belongsToCurrentSessionState(DMNDiagramElement diagramElement) {
        return this.getDMNDiagramElement(diagramElement.getId().getValue()) != null;
    }

    public Optional<DMNDiagramElement> getCurrentDMNDiagramElement() {
        return this.getSessionState().getCurrentDMNDiagramElement();
    }

    public Optional<Diagram> getCurrentDiagram() {
        return this.getSessionState().getCurrentDiagram();
    }

    public Diagram getDRGDiagram() {
        return Optional.ofNullable(this.getSessionState()).map(DMNDiagramsSessionState::getDRGDiagram).orElse(null);
    }

    public DMNDiagramElement getDRGDiagramElement() {
        return Optional.ofNullable(this.getSessionState()).map(DMNDiagramsSessionState::getDRGDiagramElement).orElse(null);
    }

    public void clear() {
        this.getSessionState().clear();
    }

    public List<DRGElement> getModelDRGElements() {
        return Optional.ofNullable(this.getSessionState()).map(DMNDiagramsSessionState::getModelDRGElements).orElse(Collections.emptyList());
    }

    public List<Import> getModelImports() {
        return Optional.ofNullable(this.getSessionState()).map(DMNDiagramsSessionState::getModelImports).orElse(Collections.emptyList());
    }

    public boolean isGlobalGraphSelected() {
        return this.getCurrentDMNDiagramElement().map(DRGDiagramUtils::isDRG).orElse(false);
    }

    public List<Graph> getGraphs() {
        return this.getDMNDiagrams().stream().map(tuple -> tuple.getStunnerDiagram().getGraph()).collect(Collectors.toList());
    }

    public List<Node> getNodesFromAllDiagramsWithContentId(String contentDefinitionId) {
        List<Node> allNodes = this.getAllNodes();
        return allNodes.stream().filter(node -> this.definitionContainsDRGElement((Node)node) && Objects.equals(this.getDRGElementFromContentDefinition((Node)node).getContentDefinitionId(), contentDefinitionId)).collect(Collectors.toList());
    }

    boolean definitionContainsDRGElement(Node node) {
        return node.getContent() instanceof Definition && ((Definition)node.getContent()).getDefinition() instanceof DRGElement;
    }

    DRGElement getDRGElementFromContentDefinition(Node node) {
        return (DRGElement)((Definition)node.getContent()).getDefinition();
    }

    public List<Node> getAllNodes() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (DMNDiagramTuple tuple : this.getDMNDiagrams()) {
            Diagram diagram = tuple.getStunnerDiagram();
            result.addAll(this.dmnDiagramUtils.getNodeStream(diagram).collect(Collectors.toList()));
        }
        return result;
    }

    public Diagram getCurrentGraphDiagram() {
        return this.getCurrentSession().map(clientSession -> this.getCanvasHandler((ClientSession)clientSession).map(CanvasHandler::getDiagram).orElse(NO_DIAGRAM)).orElse(NO_DIAGRAM);
    }

    public List<Graph> getNonGlobalGraphs() {
        return this.getDMNDiagrams().stream().filter(dmnDiagramTuple -> !DRGDiagramUtils.isDRG(dmnDiagramTuple.getDMNDiagram())).map(tuple -> tuple.getStunnerDiagram().getGraph()).collect(Collectors.toList());
    }

    Optional<ClientSession> getCurrentSession() {
        return Optional.ofNullable(this.sessionManager.getCurrentSession());
    }

    private Optional<CanvasHandler> getCanvasHandler(ClientSession session) {
        return Optional.ofNullable(session.getCanvasHandler());
    }

    void notifyRegistryChanged() {
        this.currentRegistryChangedEvent.fire((Object)new CurrentRegistryChangedEvent());
    }
}

