/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.drds;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DRGDiagramUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;

public class DMNDiagramsSessionState {
    private DMNDiagramElement currentDMNDiagramElement = null;
    private final Map<String, Diagram> diagramsByDiagramId = new HashMap<String, Diagram>();
    private final Map<String, DMNDiagramElement> dmnDiagramsByDiagramId = new HashMap<String, DMNDiagramElement>();
    private final DMNDiagramUtils dmnDiagramUtils;

    @Inject
    public DMNDiagramsSessionState(DMNDiagramUtils dmnDiagramUtils) {
        this.dmnDiagramUtils = dmnDiagramUtils;
    }

    Map<String, Diagram> getDiagramsByDiagramId() {
        return this.diagramsByDiagramId;
    }

    Map<String, DMNDiagramElement> getDMNDiagramsByDiagramId() {
        return this.dmnDiagramsByDiagramId;
    }

    Diagram getDiagram(String dmnDiagramElementId) {
        return this.diagramsByDiagramId.get(dmnDiagramElementId);
    }

    DMNDiagramElement getDMNDiagramElement(String dmnDiagramElementId) {
        return this.dmnDiagramsByDiagramId.get(dmnDiagramElementId);
    }

    DMNDiagramTuple getDiagramTuple(String dmnDiagramElementId) {
        Diagram diagram = this.getDiagram(dmnDiagramElementId);
        DMNDiagramElement dmnDiagramElement = this.getDMNDiagramElement(dmnDiagramElementId);
        return new DMNDiagramTuple(diagram, dmnDiagramElement);
    }

    List<DMNDiagramTuple> getDMNDiagrams() {
        return this.dmnDiagramsByDiagramId.values().stream().map(dmnDiagramElement -> this.getDiagramTuple(dmnDiagramElement.getId().getValue())).collect(Collectors.toList());
    }

    void setCurrentDMNDiagramElement(DMNDiagramElement currentDMNDiagramElement) {
        this.currentDMNDiagramElement = currentDMNDiagramElement;
    }

    Optional<DMNDiagramElement> getCurrentDMNDiagramElement() {
        Optional<DMNDiagramElement> currentDMNDiagramElement = Optional.ofNullable(this.currentDMNDiagramElement);
        if (currentDMNDiagramElement.isPresent()) {
            return currentDMNDiagramElement;
        }
        return Optional.ofNullable(this.getDRGDiagramElement());
    }

    Optional<Diagram> getCurrentDiagram() {
        String currentDiagramId = this.getCurrentDMNDiagramElement().map(e -> e.getId().getValue()).orElse("");
        return Optional.ofNullable(this.diagramsByDiagramId.get(currentDiagramId));
    }

    public Diagram getDRGDiagram() {
        return this.getDRGDiagramTuple().getStunnerDiagram();
    }

    DMNDiagramElement getDRGDiagramElement() {
        return this.getDRGDiagramTuple().getDMNDiagram();
    }

    DMNDiagramTuple getDRGDiagramTuple() {
        return this.getDMNDiagrams().stream().filter(t -> DRGDiagramUtils.isDRG(t.getDMNDiagram())).findFirst().orElse(null);
    }

    void clear() {
        this.diagramsByDiagramId.clear();
        this.dmnDiagramsByDiagramId.clear();
    }

    List<DRGElement> getModelDRGElements() {
        return this.getDMNDiagrams().stream().flatMap(diagram -> this.dmnDiagramUtils.getDRGElements(diagram.getStunnerDiagram()).stream()).distinct().collect(Collectors.toList());
    }

    List<Import> getModelImports() {
        Diagram drgDiagram = this.getDRGDiagram();
        return this.dmnDiagramUtils.getDefinitions(drgDiagram).getImport();
    }
}

