/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.editors.documentation.DMNDocumentationViewButtonsVisibilitySupplier;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentation;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationService;
import org.kie.workbench.common.dmn.client.editors.documentation.common.HTMLDownloadHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.stunner.core.client.util.PrintHelper;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.DefaultDiagramDocumentationView;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.core.documentation.model.DocumentationOutput;

@DMNEditor
@Dependent
@Templated
public class DMNDocumentationView
extends DefaultDiagramDocumentationView {
    static final String DOCUMENTATION_FILENAME = "Documentation";
    @DataField(value="documentation-panel")
    private final HTMLDivElement documentationPanel;
    @DataField(value="documentation-content")
    private final HTMLDivElement documentationContent;
    @DataField(value="print-button")
    private final HTMLButtonElement printButton;
    @DataField(value="download-html-file")
    private final HTMLButtonElement downloadHtmlFile;
    private final PrintHelper printHelper;
    private final DMNDocumentationService documentationService;
    private final HTMLDownloadHelper downloadHelper;
    private final DMNDocumentationViewButtonsVisibilitySupplier buttonsVisibilitySupplier;

    @Inject
    public DMNDocumentationView(HTMLDivElement documentationPanel, HTMLDivElement documentationContent, HTMLButtonElement printButton, HTMLButtonElement downloadHtmlFile, PrintHelper printHelper, DMNDocumentationService documentationService, HTMLDownloadHelper downloadHelper, DMNDocumentationViewButtonsVisibilitySupplier buttonsVisibilitySupplier) {
        this.documentationPanel = documentationPanel;
        this.documentationContent = documentationContent;
        this.printButton = printButton;
        this.downloadHtmlFile = downloadHtmlFile;
        this.printHelper = printHelper;
        this.documentationService = documentationService;
        this.downloadHelper = downloadHelper;
        this.buttonsVisibilitySupplier = buttonsVisibilitySupplier;
    }

    public DocumentationView<Diagram> refresh() {
        this.refreshDocumentationHTML();
        this.refreshDocumentationHTMLAfter200ms();
        if (!this.buttonsVisibilitySupplier.isButtonsVisible()) {
            HiddenHelper.hide((Element)this.printButton);
            HiddenHelper.hide((Element)this.downloadHtmlFile);
        }
        return this;
    }

    public boolean isEnabled() {
        return true;
    }

    @EventHandler(value={"print-button"})
    public void onPrintButtonClick(ClickEvent e) {
        this.printHelper.print((HTMLElement)this.documentationContent);
    }

    @EventHandler(value={"download-html-file"})
    public void onDownloadHtmlFile(ClickEvent e) {
        String html = this.getCurrentDocumentationHTML();
        this.downloadHelper.download(this.getCurrentDocumentationModelName(), html);
    }

    String getCurrentDocumentationHTML() {
        return this.documentationContent.innerHTML;
    }

    private String getDocumentationHTML() {
        return this.getDiagram().map(arg_0 -> ((DMNDocumentationService)this.documentationService).generate(arg_0)).map(DocumentationOutput::getValue).orElse(DocumentationOutput.EMPTY.getValue());
    }

    String getCurrentDocumentationModelName() {
        return this.getDiagram().map(diagram -> (DMNDocumentation)this.documentationService.processDocumentation((Diagram)diagram)).map(dmnDocumentation -> "Documentation-" + dmnDocumentation.getDiagramName()).orElse(DOCUMENTATION_FILENAME);
    }

    void refreshDocumentationHTML() {
        this.documentationContent.innerHTML = this.getDocumentationHTML();
    }

    void refreshDocumentationHTMLAfter200ms() {
        this.setTimeout(w -> this.refreshDocumentationHTML(), 200);
    }

    void setTimeout(DomGlobal.SetTimeoutCallbackFn callback, int delay) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)callback, (double)delay, (Object[])new Object[0]);
    }
}

