/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DMNIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DefaultIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.PMMLIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.ImportRecordEngine;
import org.uberfire.commons.uuid.UUID;

@ApplicationScoped
public class IncludedModelsFactory {
    private final ImportRecordEngine recordEngine;
    private final IncludedModelsIndex includedModelsIndex;

    @Inject
    public IncludedModelsFactory(ImportRecordEngine recordEngine, IncludedModelsIndex includedModelsIndex) {
        this.recordEngine = recordEngine;
        this.includedModelsIndex = includedModelsIndex;
    }

    List<BaseIncludedModelActiveRecord> makeIncludedModels(List<Import> imports) {
        this.getIncludedModelsIndex().clear();
        return imports.stream().map(this::makeIncludedModel).collect(Collectors.toList());
    }

    protected String uuidWrapper() {
        return UUID.uuid();
    }

    private BaseIncludedModelActiveRecord makeIncludedModel(Import anImport) {
        BaseIncludedModelActiveRecord includedModel;
        if (anImport instanceof ImportDMN) {
            DMNIncludedModelActiveRecord dmnIncludedModel = new DMNIncludedModelActiveRecord(this.getRecordEngine());
            dmnIncludedModel.setDataTypesCount(this.getDataTypesCount((ImportDMN)anImport));
            dmnIncludedModel.setDrgElementsCount(this.getDrgElementsCount((ImportDMN)anImport));
            includedModel = dmnIncludedModel;
        } else if (anImport instanceof ImportPMML) {
            PMMLIncludedModelActiveRecord pmmlIncludedModel = new PMMLIncludedModelActiveRecord(this.getRecordEngine());
            pmmlIncludedModel.setModelCount(this.getPMMLModelCount((ImportPMML)anImport));
            includedModel = pmmlIncludedModel;
        } else {
            includedModel = new DefaultIncludedModelActiveRecord(this.getRecordEngine());
        }
        includedModel.setUuid(this.uuidWrapper());
        includedModel.setName(this.getName(anImport));
        includedModel.setNamespace(this.getNamespace(anImport));
        includedModel.setImportType(this.getImportType(anImport));
        includedModel.setPath(this.getPath(anImport));
        this.getIncludedModelsIndex().index(includedModel, anImport);
        return includedModel;
    }

    public IncludedModelsIndex getIncludedModelsIndex() {
        return this.includedModelsIndex;
    }

    public ImportRecordEngine getRecordEngine() {
        return this.recordEngine;
    }

    private String getName(Import anImport) {
        return anImport.getName().getValue();
    }

    private String getPath(Import anImport) {
        return anImport.getLocationURI().getValue();
    }

    private String getNamespace(Import anImport) {
        return anImport.getNamespace();
    }

    private String getImportType(Import anImport) {
        return anImport.getImportType();
    }

    private int getDataTypesCount(ImportDMN anImport) {
        return anImport.getItemDefinitionsCount();
    }

    private int getDrgElementsCount(ImportDMN anImport) {
        return anImport.getDrgElementsCount();
    }

    private int getPMMLModelCount(ImportPMML anImport) {
        return anImport.getModelCount();
    }
}

