/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.uberfire.ext.editor.commons.client.file.popups.elemental2.Elemental2Modal;

@Dependent
public class ImportDataObjectModal
extends Elemental2Modal<View> {
    private final DMNClientServicesProxy client;
    private Consumer<List<DataObject>> dataObjectsConsumer;
    private List<String> existingDataTypes;

    @Inject
    public ImportDataObjectModal(View view, DMNClientServicesProxy client) {
        super((Elemental2Modal.View)view);
        this.client = client;
    }

    public Consumer<List<DataObject>> getDataObjectsConsumer() {
        return this.dataObjectsConsumer;
    }

    public void setup(Consumer<List<DataObject>> dataObjectsConsumer) {
        this.dataObjectsConsumer = dataObjectsConsumer;
        this.callSuperSetup();
    }

    Consumer<List<DataObject>> getOnDataObjectSelectionChanged() {
        return this::onDataObjectSelectionChanged;
    }

    void onDataObjectSelectionChanged(List<DataObject> dataObjects) {
        if (dataObjects.stream().anyMatch(dataObject -> this.getExistingDataTypes().contains(dataObject.getClassNameWithoutPackage()))) {
            ((View)this.getView()).showDataTypeWithSameNameWarning();
        } else {
            ((View)this.getView()).hideDataTypeWithSameNameWarning();
        }
    }

    void callSuperSetup() {
        super.setup();
    }

    public void hide(List<DataObject> importedDataObjects) {
        if (!Objects.isNull(this.getDataObjectsConsumer())) {
            this.getDataObjectsConsumer().accept(importedDataObjects);
        }
        this.superHide();
    }

    void superHide() {
        super.hide();
    }

    public void show(List<String> existingDataTypes) {
        ((View)this.getView()).hideDataTypeWithSameNameWarning();
        this.existingDataTypes = existingDataTypes;
        this.client.loadDataObjects(this.wrap(this.getConsumer()));
        this.superShow();
    }

    public List<String> getExistingDataTypes() {
        return this.existingDataTypes;
    }

    ServiceCallback<List<DataObject>> wrap(final Consumer<List<DataObject>> consumer) {
        return new ServiceCallback<List<DataObject>>(){

            public void onSuccess(List<DataObject> items) {
                consumer.accept(items);
            }

            public void onError(ClientRuntimeError error) {
            }
        };
    }

    Consumer<List<DataObject>> getConsumer() {
        return objects -> {
            ((View)this.getView()).clear();
            ((View)this.getView()).addItems((List<DataObject>)objects);
            this.superShow();
        };
    }

    void superShow() {
        super.show();
    }

    public static interface View
    extends Elemental2Modal.View<ImportDataObjectModal> {
        public void addItems(List<DataObject> var1);

        public void clear();

        public void showDataTypeWithSameNameWarning();

        public void hideDataTypeWithSameNameWarning();
    }
}

