/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.api.editors.types.DataObjectProperty;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListHighlightHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeStackHash;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandler;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.uberfire.client.mvp.UberElemental;

@ApplicationScoped
public class DataTypeList {
    static final String NAME_SEPARATOR = "-";
    private final View view;
    private final ManagedInstance<DataTypeListItem> listItems;
    private final DataTypeManager dataTypeManager;
    private final DataTypeSearchBar searchBar;
    private final DataTypeStackHash dataTypeStackHash;
    private final DNDListComponent dndListComponent;
    private final DNDDataTypesHandler dndDataTypesHandler;
    private final DataTypeListHighlightHelper highlightHelper;
    private Consumer<DataTypeListItem> onDataTypeListItemUpdate = e -> {};
    private List<DataTypeListItem> items = new ArrayList<DataTypeListItem>();
    private DataTypeListItem currentEditingItem;
    private Map<String, Integer> importedNamesOccurrencesCount;
    private Map<String, String> renamedImportedDataTypes;

    @Inject
    public DataTypeList(View view, ManagedInstance<DataTypeListItem> listItems, DataTypeManager dataTypeManager, DataTypeSearchBar searchBar, DNDListComponent dndListComponent, DataTypeStackHash dataTypeStackHash, DNDDataTypesHandler dndDataTypesHandler, DataTypeListHighlightHelper highlightHelper) {
        this.view = view;
        this.listItems = listItems;
        this.dataTypeManager = dataTypeManager;
        this.searchBar = searchBar;
        this.dndListComponent = dndListComponent;
        this.dataTypeStackHash = dataTypeStackHash;
        this.dndDataTypesHandler = dndDataTypesHandler;
        this.highlightHelper = highlightHelper;
        this.importedNamesOccurrencesCount = new HashMap<String, Integer>();
        this.renamedImportedDataTypes = new HashMap<String, String>();
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
        this.highlightHelper.init(this);
        this.dndDataTypesHandler.init(this);
        this.dndListComponent.setOnDropItem(this.getOnDropDataType());
        this.view.showImportDataObjectButton();
    }

    BiConsumer<Element, Element> getOnDropDataType() {
        return this.dndDataTypesHandler::onDropDataType;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void setupItems(List<DataType> dataTypes) {
        this.setupItemsView(dataTypes);
        this.setupViewElements();
        this.collapseItemsInTheFirstLevel();
    }

    private void setupItemsView(List<DataType> dataTypes) {
        this.getDNDListComponent().clear();
        this.setListItems(this.makeDataTypeListItems(dataTypes));
        this.getDNDListComponent().refreshItemsPosition();
    }

    private void setupViewElements() {
        this.view.showOrHideNoCustomItemsMessage();
        this.view.showReadOnlyMessage(this.hasReadOnlyDataTypes());
    }

    List<DataTypeListItem> makeDataTypeListItems(List<DataType> dataTypes) {
        ArrayList<DataTypeListItem> listItems = new ArrayList<DataTypeListItem>();
        dataTypes.forEach(dt -> listItems.addAll(this.makeTreeListItems((DataType)dt, 1)));
        return listItems;
    }

    void refreshSubItemsFromListItem(DataTypeListItem listItem, List<DataType> subDataTypes) {
        DataType dataType = listItem.getDataType();
        int level = listItem.getLevel();
        ArrayList<DataTypeListItem> listItems = new ArrayList<DataTypeListItem>();
        for (DataType subDataType : subDataTypes) {
            listItems.addAll(this.makeTreeListItems(subDataType, level + 1));
        }
        List<HTMLElement> children = listItems.stream().map(e -> e.getDragAndDropElement()).collect(Collectors.toList());
        this.dndListComponent.setInitialPositionY(listItem.getDragAndDropElement(), children);
        this.cleanAndUnIndex(dataType);
        this.addNewSubItems(dataType, listItems);
        listItems.forEach(this::reIndexDataTypes);
        this.getItems().addAll(listItems);
    }

    private void reIndexDataTypes(DataTypeListItem listItem) {
        this.dataTypeManager.from(listItem.getDataType()).withIndexedItemDefinition();
    }

    private void addNewSubItems(DataType dataType, List<DataTypeListItem> gridItems) {
        this.view.addSubItems(dataType, gridItems);
    }

    private void cleanAndUnIndex(DataType dataType) {
        this.view.cleanSubTypes(dataType);
    }

    List<DataTypeListItem> makeTreeListItems(DataType dataType, int level) {
        DataTypeListItem listItem = this.makeListItem();
        List<DataType> subDataTypes = dataType.getSubDataTypes();
        ArrayList<DataTypeListItem> gridItems = new ArrayList<DataTypeListItem>();
        listItem.setupDataType(dataType, level);
        gridItems.add(listItem);
        for (DataType subDataType : subDataTypes) {
            gridItems.addAll(this.makeTreeListItems(subDataType, level + 1));
        }
        return gridItems;
    }

    DataTypeListItem makeListItem() {
        DataTypeListItem listItem = (DataTypeListItem)this.listItems.get();
        listItem.init(this);
        return listItem;
    }

    void removeItem(DataType dataType) {
        this.removeItem(dataType.getUUID());
        this.view.removeItem(dataType);
    }

    void removeItem(String uuid) {
        this.getItems().removeIf(listItem -> Objects.equals(uuid, listItem.getDataType().getUUID()));
    }

    void refreshItemsByUpdatedDataTypes(List<DataType> updateDataTypes) {
        for (DataType dataType : updateDataTypes) {
            this.findItem(dataType).ifPresent(listItem -> {
                listItem.refresh();
                this.refreshSubItemsFromListItem((DataTypeListItem)listItem, dataType.getSubDataTypes());
            });
        }
        this.refreshDragAndDropList();
        this.refreshSearchBar();
    }

    public Optional<DataTypeListItem> findItem(DataType dataType) {
        return this.getItems().stream().filter(item -> Objects.equals(item.getDataType().getUUID(), dataType.getUUID())).findFirst();
    }

    public DNDListComponent getDNDListComponent() {
        return this.dndListComponent;
    }

    private boolean hasReadOnlyDataTypes() {
        return this.getItems().stream().anyMatch(DataTypeListItem::isReadOnly);
    }

    public List<DataTypeListItem> getItems() {
        return this.items;
    }

    void setListItems(List<DataTypeListItem> items) {
        this.items = items;
    }

    void collapseItemsInTheFirstLevel() {
        this.getItems().stream().filter(typeListItem -> typeListItem.getLevel() == 1).forEach(DataTypeListItem::collapse);
    }

    void addDataType() {
        this.addDataType(this.dataTypeManager.fromNew().get(), true);
    }

    void addDataType(DataType dataType, boolean enableEditMode) {
        this.resetSearchBar();
        DataTypeListItem listItem = this.makeListItem(dataType);
        dataType.create();
        this.showListItems();
        listItem.refresh();
        if (enableEditMode) {
            listItem.enableEditMode();
        }
        this.refreshItemsCSSAndHTMLPosition();
    }

    void insertBelow(DataType dataType, DataType reference) {
        DataTypeListItem listItem = this.makeListItem(dataType);
        this.view.insertBelow(listItem, reference);
        this.refreshItemsByUpdatedDataTypes(Collections.singletonList(listItem.getDataType()));
    }

    void insertAbove(DataType dataType, DataType reference) {
        this.view.insertAbove(this.makeListItem(dataType), reference);
        this.refreshDragAndDropList();
    }

    public void showNoDataTypesFound() {
        this.view.showNoDataTypesFound();
    }

    public void showListItems() {
        this.view.showOrHideNoCustomItemsMessage();
    }

    DataTypeListItem makeListItem(DataType dataType) {
        List<DataTypeListItem> items = this.makeTreeListItems(dataType, 1);
        this.getItems().addAll(items);
        return items.get(0);
    }

    void expandAll() {
        if (!this.getSearchBar().isEnabled()) {
            this.getItems().forEach(DataTypeListItem::expand);
        }
    }

    public void collapseAll() {
        if (!this.getSearchBar().isEnabled()) {
            this.getItems().forEach(DataTypeListItem::collapse);
        }
    }

    DataTypeSearchBar getSearchBar() {
        return this.searchBar;
    }

    public void enableEditMode(String dataTypeHash) {
        this.findItemByDataTypeHash(dataTypeHash).ifPresent(DataTypeListItem::enableEditMode);
    }

    public void registerDataTypeListItemUpdateCallback(Consumer<DataTypeListItem> onDataTypeListItemUpdate) {
        this.onDataTypeListItemUpdate = onDataTypeListItemUpdate;
    }

    void insertNestedField(String dataTypeHash) {
        this.findItemByDataTypeHash(dataTypeHash).ifPresent(DataTypeListItem::insertNestedField);
    }

    void fireOnDataTypeListItemUpdateCallback(String dataTypeHash) {
        this.findItemByDataTypeHash(dataTypeHash).ifPresent(this::fireOnDataTypeListItemUpdateCallback);
    }

    void fireOnDataTypeListItemUpdateCallback(DataTypeListItem listItem) {
        this.onDataTypeListItemUpdate.accept(listItem);
    }

    public Optional<DataTypeListItem> findItemByDataTypeHash(String dataTypeHash) {
        return this.getItems().stream().filter(item -> Objects.equals(this.calculateHash(item.getDataType()), dataTypeHash)).findFirst();
    }

    String calculateParentHash(DataType dataType) {
        return this.dataTypeStackHash.calculateParentHash(dataType);
    }

    public String calculateHash(DataType dataType) {
        return this.dataTypeStackHash.calculateHash(dataType);
    }

    public void onDataTypeEditModeToggle(@Observes DataTypeEditModeToggleEvent event) {
        this.resetSearchBar();
        if (event.isEditModeEnabled()) {
            if (this.getCurrentEditingItem() != null && this.getItems().contains(this.getCurrentEditingItem())) {
                this.getCurrentEditingItem().disableEditMode();
            }
            this.setCurrentEditingItem(event.getItem());
        } else if (Objects.equals(event.getItem(), this.getCurrentEditingItem())) {
            this.setCurrentEditingItem(null);
        }
    }

    void refreshDragAndDropList() {
        this.getDNDListComponent().consolidateYPosition();
        this.getDNDListComponent().refreshItemsPosition();
    }

    DataTypeListItem getCurrentEditingItem() {
        return this.currentEditingItem;
    }

    void setCurrentEditingItem(DataTypeListItem currentEditingItem) {
        this.currentEditingItem = currentEditingItem;
    }

    void refreshItemsCSSAndHTMLPosition() {
        this.dndListComponent.refreshItemsCSSAndHTMLPosition();
    }

    public HTMLElement getListItems() {
        return this.view.getListItems();
    }

    private void resetSearchBar() {
        this.searchBar.reset();
    }

    private void refreshSearchBar() {
        this.searchBar.refresh();
    }

    public void importDataObjects(List<DataObject> selectedDataObjects) {
        this.removeFullQualifiedNames(selectedDataObjects);
        for (DataObject dataObject : selectedDataObjects) {
            DataType newDataType = this.createNewDataType(dataObject);
            Optional<DataType> existing = this.findDataTypeByName(dataObject.getClassType());
            if (existing.isPresent()) {
                this.replace(existing.get(), newDataType);
            } else {
                this.insert(newDataType);
            }
            this.insertProperties(dataObject);
        }
    }

    void removeFullQualifiedNames(List<DataObject> imported) {
        Map<String, Integer> namesCount = this.getImportedNamesOccurrencesCount();
        Map<String, String> renamed = this.getRenamedImportedDataTypes();
        namesCount.clear();
        renamed.clear();
        for (DataObject dataObject : imported) {
            String nameCandidate = dataObject.getClassNameWithoutPackage();
            String newName = this.buildName(nameCandidate, namesCount);
            renamed.put(dataObject.getClassType(), newName);
            dataObject.setClassType(newName);
        }
        this.updatePropertiesReferences(imported, renamed);
    }

    Map<String, Integer> getImportedNamesOccurrencesCount() {
        return this.importedNamesOccurrencesCount;
    }

    Map<String, String> getRenamedImportedDataTypes() {
        return this.renamedImportedDataTypes;
    }

    void updatePropertiesReferences(List<DataObject> imported, Map<String, String> renamed) {
        for (DataObject dataObject : imported) {
            for (DataObjectProperty property : dataObject.getProperties()) {
                String propertyType = renamed.getOrDefault(property.getType(), property.getType());
                if (!this.isPropertyTypePresent(propertyType, imported)) {
                    propertyType = BuiltInType.ANY.getName();
                }
                property.setType(propertyType);
            }
        }
    }

    boolean isPropertyTypePresent(String type, List<DataObject> imported) {
        return BuiltInTypeUtils.isBuiltInType((String)type) || imported.stream().anyMatch(dataObject -> Objects.equals(dataObject.getClassType(), type));
    }

    String buildName(String nameCandidate, Map<String, Integer> namesCount) {
        if (namesCount.containsKey(nameCandidate)) {
            Integer occurrences = namesCount.get(nameCandidate);
            namesCount.replace(nameCandidate, occurrences + 1);
            return nameCandidate + NAME_SEPARATOR + occurrences;
        }
        namesCount.put(nameCandidate, 1);
        return nameCandidate;
    }

    void insertProperties(DataObject dataObject) {
        Optional<DataType> existing = this.findDataTypeByName(dataObject.getClassType());
        existing.ifPresent(dataType -> this.findItem((DataType)dataType).ifPresent(item -> {
            for (DataObjectProperty property : dataObject.getProperties()) {
                DataType newDataType = this.createNewDataType(property);
                item.insertNestedField(newDataType);
            }
        }));
    }

    void insert(DataType newDataType) {
        this.addDataType(newDataType, false);
    }

    void replace(DataType existing, DataType newDataType) {
        this.dndDataTypesHandler.deleteKeepingReferences(existing);
        this.insert(newDataType);
    }

    DataType createNewDataType(DataObjectProperty dataProperty) {
        DataType newDataType = this.dataTypeManager.fromNew().withType(dataProperty.getType()).asList(dataProperty.isList()).get();
        newDataType.setName(dataProperty.getProperty());
        return newDataType;
    }

    DataType createNewDataType(DataObject dataObject) {
        DataType newDataType = this.dataTypeManager.fromNew().withType(this.dataTypeManager.structure()).get();
        newDataType.setName(dataObject.getClassType());
        return newDataType;
    }

    Optional<DataType> findDataTypeByName(String name) {
        return this.dataTypeManager.getTopLevelDataTypeWithName(name);
    }

    public void disableEditModeForChildren(DataTypeListItem dataTypeListItem) {
        String uuid = dataTypeListItem.getDataType().getUUID();
        this.getItems().stream().filter(item -> Objects.equals(item.getDataType().getParentUUID(), uuid)).forEach(child -> {
            child.disableEditMode();
            this.disableEditModeForChildren((DataTypeListItem)child);
        });
    }

    public List<String> getExistingDataTypesNames() {
        return this.getItems().stream().filter(item -> item.getDataType().isTopLevel()).map(item -> item.getDataType().getName()).collect(Collectors.toList());
    }

    public void highlightLevel(DataType dataType) {
        this.highlightHelper.highlightLevel(dataType);
    }

    public void highlightLevel(Element element) {
        this.highlightHelper.highlightLevel(element);
    }

    public void highlight(Element element) {
        this.highlightHelper.highlight(element);
    }

    public void cleanLevelHighlightClass() {
        this.highlightHelper.cleanLevelHighlightClass();
    }

    public void cleanHighlightClass() {
        this.highlightHelper.cleanHighlightClass();
    }

    public static interface View
    extends UberElemental<DataTypeList>,
    IsElement {
        public void showOrHideNoCustomItemsMessage();

        public void addSubItems(DataType var1, List<DataTypeListItem> var2);

        public void removeItem(DataType var1);

        public void cleanSubTypes(DataType var1);

        public void insertBelow(DataTypeListItem var1, DataType var2);

        public void insertAbove(DataTypeListItem var1, DataType var2);

        public void showNoDataTypesFound();

        public void showReadOnlyMessage(boolean var1);

        public void showImportDataObjectButton();

        public void hideImportDataObjectButton();

        public HTMLElement getListItems();
    }
}

