/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;

public class DataTypeListHighlightHelper {
    static final String HIGHLIGHT = "key-highlight";
    static final String LEVEL_HIGHLIGHT = "kie-level-highlight";
    static final String LEVEL_BACKGROUND_LINE = "kie-level-background-line";
    private final DataTypeUtils dataTypeUtils;
    private DataTypeList dataTypeList;

    @Inject
    public DataTypeListHighlightHelper(DataTypeUtils dataTypeUtils) {
        this.dataTypeUtils = dataTypeUtils;
    }

    public void init(DataTypeList dataTypeList) {
        this.dataTypeList = dataTypeList;
    }

    public void highlightLevel(Element element) {
        this.getDataTypeListItem(this.getUUID(element)).ifPresent(listItem -> {
            this.cleanLevelHighlightClass();
            this.highlightLevel(this.dataTypeUtils.getTopLevelParent(listItem.getDataType()));
        });
    }

    public void highlight(Element element) {
        this.cleanHighlightClass();
        element.classList.add(new String[]{HIGHLIGHT});
    }

    public void cleanHighlightClass() {
        this.cleanCSSClass(HIGHLIGHT);
    }

    public void cleanLevelHighlightClass() {
        this.cleanBackgroundLine();
        this.cleanCSSClass(LEVEL_HIGHLIGHT);
    }

    Optional<DataTypeListItem> getDataTypeListItem(String uuid) {
        return this.getDataTypeList().getItems().stream().filter(item -> Objects.equals(item.getDataType().getUUID(), uuid)).findFirst();
    }

    NodeList<Element> querySelectorAll(String selector) {
        return this.getDataTypeList().getElement().querySelectorAll(selector);
    }

    void highlightLevel(DataType dataType) {
        this.getDataTypeListItem(dataType.getUUID()).ifPresent(listItem -> {
            HTMLElement element = listItem.getDragAndDropElement();
            List<DataType> subDataTypes = dataType.getSubDataTypes();
            boolean topLevel = dataType.isTopLevel();
            this.highlightLevel((DataTypeListItem)listItem);
            subDataTypes.forEach(this::highlightLevel);
            if (topLevel && !this.hasBackgroundLine(element)) {
                this.appendBackgroundLine(dataType, element);
            }
        });
    }

    void appendBackgroundLine(DataType dataType, HTMLElement element) {
        int numberOfDataTypes = this.numberOfSubDataTypes(dataType) + this.numberOfDraggingElements();
        Element backgroundLine = this.createBackgroundLine();
        int dataTypeRow = element.offsetHeight;
        int lineHeight = dataTypeRow * numberOfDataTypes;
        element.appendChild((Node)backgroundLine);
        backgroundLine.setAttribute("style", "height: " + lineHeight + "px");
    }

    private int numberOfDraggingElements() {
        return this.querySelectorAll((String)".kie-dnd-current-dragging").length;
    }

    private Element createBackgroundLine() {
        Element line = this.createElement("div");
        line.classList.add(new String[]{LEVEL_BACKGROUND_LINE});
        return line;
    }

    Element createElement(String tagName) {
        return DomGlobal.document.createElement(tagName);
    }

    boolean hasBackgroundLine(HTMLElement element) {
        return element.querySelector(".kie-level-background-line") != null;
    }

    private void cleanBackgroundLine() {
        NodeList<Element> elementNodeList = this.querySelectorAll(".kie-level-background-line");
        for (int i = 0; i < elementNodeList.length; ++i) {
            Element e = (Element)elementNodeList.getAt(i);
            e.parentNode.removeChild((Node)e);
        }
    }

    private int numberOfSubDataTypes(DataType dataType) {
        boolean isExpanded;
        boolean bl = isExpanded = this.getDataTypeListItem(dataType.getUUID()).map(DataTypeListItem::isCollapsed).orElse(false) == false;
        if (isExpanded) {
            return dataType.getSubDataTypes().stream().map(this::numberOfSubDataTypes).reduce(1, Integer::sum);
        }
        return 1;
    }

    private void highlightLevel(DataTypeListItem listItem) {
        HTMLElement element = listItem.getDragAndDropElement();
        element.classList.add(new String[]{LEVEL_HIGHLIGHT});
    }

    private String getUUID(Element element) {
        return element.getAttribute("data-row-uuid");
    }

    private void cleanCSSClass(String cssClass) {
        NodeList<Element> highlightedElements = this.querySelectorAll("." + cssClass);
        for (int i = 0; i < highlightedElements.length; ++i) {
            ((Element)highlightedElements.getAt((int)i)).classList.remove(new String[]{cssClass});
        }
    }

    public DataTypeList getDataTypeList() {
        return Optional.ofNullable(this.dataTypeList).orElseThrow(() -> {
            String errorMessage = "DataTypeListHighlightHelper error 'dataTypeList' must be initialized.";
            return new UnsupportedOperationException("DataTypeListHighlightHelper error 'dataTypeList' must be initialized.");
        });
    }
}

