/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.ScrollHelper;
import org.kie.workbench.common.dmn.client.editors.types.imported.ImportDataObjectModal;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.ListItemViewCssHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.uberfire.client.views.pfly.selectpicker.ElementHelper;

@Templated
@ApplicationScoped
public class DataTypeListView
implements DataTypeList.View {
    @DataField(value="list-items")
    private final HTMLDivElement listItems;
    @DataField(value="placeholder")
    private final HTMLDivElement placeholder;
    @DataField(value="add-button")
    private final HTMLButtonElement addButton;
    @DataField(value="add-button-placeholder")
    private final HTMLButtonElement addButtonPlaceholder;
    @DataField(value="data-type-button")
    private final HTMLDivElement dataTypeButton;
    @DataField(value="search-bar-container")
    private final HTMLDivElement searchBarContainer;
    @DataField(value="expand-all")
    private final HTMLAnchorElement expandAll;
    @DataField(value="collapse-all")
    private final HTMLAnchorElement collapseAll;
    @DataField(value="no-data-types-found")
    private final HTMLDivElement noDataTypesFound;
    @DataField(value="read-only-message")
    private final HTMLDivElement readOnlyMessage;
    @DataField(value="read-only-message-close-button")
    private final HTMLButtonElement readOnlyMessageCloseButton;
    @DataField(value="import-data-object-button")
    private final HTMLButtonElement importDataObjectButton;
    private final ScrollHelper scrollHelper;
    private final ImportDataObjectModal importDataObjectModal;
    private final Event<FlashMessage> flashMessageEvent;
    private final TranslationService translationService;
    private final ReadOnlyProvider readOnlyProvider;
    private DataTypeList presenter;

    @Inject
    public DataTypeListView(HTMLDivElement listItems, HTMLButtonElement addButton, HTMLButtonElement addButtonPlaceholder, HTMLDivElement dataTypeButton, HTMLDivElement placeholder, HTMLDivElement searchBarContainer, HTMLAnchorElement expandAll, HTMLAnchorElement collapseAll, HTMLDivElement noDataTypesFound, HTMLDivElement readOnlyMessage, HTMLButtonElement readOnlyMessageCloseButton, ScrollHelper scrollHelper, HTMLButtonElement importDataObjectButton, ImportDataObjectModal importDataObjectModal, Event<FlashMessage> flashMessageEvent, TranslationService translationService, ReadOnlyProvider readOnlyProvider) {
        this.listItems = listItems;
        this.addButton = addButton;
        this.addButtonPlaceholder = addButtonPlaceholder;
        this.dataTypeButton = dataTypeButton;
        this.placeholder = placeholder;
        this.searchBarContainer = searchBarContainer;
        this.expandAll = expandAll;
        this.collapseAll = collapseAll;
        this.noDataTypesFound = noDataTypesFound;
        this.readOnlyMessage = readOnlyMessage;
        this.readOnlyMessageCloseButton = readOnlyMessageCloseButton;
        this.scrollHelper = scrollHelper;
        this.importDataObjectButton = importDataObjectButton;
        this.importDataObjectModal = importDataObjectModal;
        this.flashMessageEvent = flashMessageEvent;
        this.translationService = translationService;
        this.readOnlyProvider = readOnlyProvider;
    }

    public void init(DataTypeList presenter) {
        this.presenter = presenter;
        this.setupSearchBar();
        this.importDataObjectModal.setup(this::importDataObjects);
        this.setupListElement();
        this.setupAddButtonReadOnlyStatus();
    }

    void setupAddButtonReadOnlyStatus() {
        this.addButton.disabled = this.readOnlyProvider.isReadOnlyDiagram();
    }

    void importDataObjects(List<DataObject> imported) {
        this.presenter.importDataObjects(imported);
        if (!imported.isEmpty()) {
            this.fireSuccessfullyImportedData();
        }
    }

    void fireSuccessfullyImportedData() {
        this.flashMessageEvent.fire((Object)new FlashMessage(FlashMessage.Type.SUCCESS, this.translationService.getTranslation("DataTypeSuccessfullyImportedMessage.RegularMessage"), ""));
    }

    private void setupSearchBar() {
        this.searchBarContainer.appendChild((Node)this.presenter.getSearchBar().getElement());
    }

    private void setupListElement() {
        this.listItems.appendChild((Node)this.getDndListComponent().getElement());
    }

    private DNDListComponent getDndListComponent() {
        return this.presenter.getDNDListComponent();
    }

    @Override
    public void showOrHideNoCustomItemsMessage() {
        if (!this.hasCustomDataType()) {
            this.showPlaceHolder();
        } else {
            this.showListItems();
        }
    }

    boolean hasCustomDataType() {
        NodeList childNodes = this.listItems.querySelectorAll("[data-row-uuid]");
        return !Objects.isNull(childNodes) && childNodes.length > 0;
    }

    @Override
    public void addSubItems(DataType dataType, List<DataTypeListItem> listItems) {
        Element parent = this.getDataTypeRow(dataType);
        for (DataTypeListItem item : listItems) {
            HTMLElement itemElement = item.getDragAndDropElement();
            this.hideItemElementIfParentIsCollapsed(itemElement, parent);
            ElementHelper.insertAfter((Node)itemElement, (Node)parent);
            parent = itemElement;
        }
        this.showArrowIconIfDataTypeHasChildren(dataType);
        this.showOrHideNoCustomItemsMessage();
    }

    @EventHandler(value={"expand-all"})
    public void expandAll(ClickEvent e) {
        this.presenter.expandAll();
    }

    @EventHandler(value={"collapse-all"})
    public void collapseAll(ClickEvent e) {
        this.presenter.collapseAll();
    }

    @EventHandler(value={"add-button", "add-button-placeholder"})
    public void onAddButtonClick(ClickEvent e) {
        this.scrollHelper.animatedScrollToBottom((Element)this.listItems);
        this.presenter.addDataType();
    }

    @EventHandler(value={"import-data-object-button"})
    public void onImportDataObjectClick(ClickEvent e) {
        this.importDataObjectModal.show(this.presenter.getExistingDataTypesNames());
    }

    @EventHandler(value={"read-only-message-close-button"})
    public void onReadOnlyMessageCloseButtonClick(ClickEvent e) {
        HiddenHelper.hide((Element)this.readOnlyMessage);
    }

    void hideItemElementIfParentIsCollapsed(HTMLElement itemElement, Element parent) {
        boolean isCollapsedParent = this.isCollapsed(parent.querySelector("[data-type-field=\"arrow-button\"]"));
        boolean isHiddenParent = HiddenHelper.isHidden(parent);
        if (isCollapsedParent || isHiddenParent) {
            HiddenHelper.hide((Element)itemElement);
            this.getDndListComponent().setInitialHiddenPositionY(itemElement);
        } else {
            HiddenHelper.show((Element)itemElement);
        }
    }

    void showArrowIconIfDataTypeHasChildren(DataType dataType) {
        if (this.hasChildren(dataType)) {
            HiddenHelper.show(this.getDataTypeRow(dataType).querySelector("[data-type-field=\"arrow-button\"]"));
        } else {
            HiddenHelper.hide(this.getDataTypeRow(dataType).querySelector("[data-type-field=\"arrow-button\"]"));
        }
    }

    private boolean hasChildren(DataType dataType) {
        return this.listItems.querySelectorAll((String)new StringBuilder().append((String)"[data-parent-row-uuid=\"").append((String)dataType.getUUID()).append((String)"\"]").toString()).length > 0;
    }

    @Override
    public void removeItem(DataType dataType) {
        this.cleanSubTypes(dataType.getUUID());
        Optional<Element> dataTypeRow = Optional.ofNullable(this.getDataTypeRow(dataType));
        dataTypeRow.ifPresent(this::removeDataTypeRow);
        this.showOrHideNoCustomItemsMessage();
    }

    @Override
    public void cleanSubTypes(DataType dataType) {
        this.cleanSubTypes(dataType.getUUID());
    }

    void cleanSubTypes(String uuid) {
        String selector = "[data-parent-row-uuid=\"" + uuid + "\"]";
        NodeList subDataTypeRows = this.listItems.querySelectorAll(selector);
        for (int i = 0; i < subDataTypeRows.length; ++i) {
            Element item = (Element)subDataTypeRows.getAt(i);
            if (item == null || item.parentNode == null) continue;
            this.cleanSubTypes(item.getAttribute("data-row-uuid"));
            this.removeDataTypeRow(item);
        }
    }

    private void removeDataTypeRow(Element item) {
        this.presenter.removeItem(item.getAttribute("data-row-uuid"));
        ElementHelper.remove((Node)item);
    }

    @Override
    public void insertBelow(DataTypeListItem listItem, DataType reference) {
        Element elementReference = this.getLastSubDataTypeElement(reference);
        ElementHelper.insertAfter((Node)listItem.getDragAndDropElement(), (Node)elementReference);
        this.setNewElementYPosition(elementReference, (Element)listItem.getDragAndDropElement());
    }

    @Override
    public void insertAbove(DataTypeListItem listItem, DataType reference) {
        Element elementReference = this.getDataTypeRow(reference);
        ElementHelper.insertBefore((Node)listItem.getDragAndDropElement(), (Node)elementReference);
        this.setNewElementYPosition(elementReference, (Element)listItem.getDragAndDropElement());
    }

    void setNewElementYPosition(Element elementReference, Element newElement) {
        int referencePosition = this.getDndListComponent().getPositionY(elementReference);
        this.getDndListComponent().setPositionY(newElement, referencePosition);
    }

    private boolean isCollapsed(Element arrow) {
        return ListItemViewCssHelper.isRightArrow(arrow);
    }

    Element getDataTypeRow(DataType dataType) {
        return this.listItems.querySelector("[data-row-uuid=\"" + dataType.getUUID() + "\"]");
    }

    Element getLastSubDataTypeElement(DataType reference) {
        return this.getLastSubDataTypeElement(this.getDataTypeRow(reference));
    }

    Element getLastSubDataTypeElement(Element element) {
        String parentUUID = element.getAttribute("data-row-uuid");
        List<Element> nestedElements = this.getNestedElements(parentUUID);
        if (nestedElements.isEmpty()) {
            return element;
        }
        return this.getLastSubDataTypeElement(nestedElements.get(nestedElements.size() - 1));
    }

    private List<Element> getNestedElements(String parentUUID) {
        String selector = "[data-parent-row-uuid=\"" + parentUUID + "\"]";
        NodeList nestedElements = this.listItems.querySelectorAll(selector);
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < nestedElements.length; ++i) {
            boolean isVisible;
            Element element = (Element)nestedElements.getAt(i);
            boolean bl = isVisible = this.getDndListComponent().getPositionY(element) > -1;
            if (!isVisible) continue;
            list.add(element);
        }
        return list;
    }

    @Override
    public void showNoDataTypesFound() {
        HiddenHelper.show((Element)this.noDataTypesFound);
        HiddenHelper.hide((Element)this.placeholder);
        HiddenHelper.hide((Element)this.listItems);
    }

    void showListItems() {
        HiddenHelper.hide((Element)this.noDataTypesFound);
        HiddenHelper.hide((Element)this.placeholder);
        HiddenHelper.show((Element)this.dataTypeButton);
        HiddenHelper.show((Element)this.listItems);
    }

    void showPlaceHolder() {
        HiddenHelper.hide((Element)this.noDataTypesFound);
        HiddenHelper.show((Element)this.placeholder);
        HiddenHelper.hide((Element)this.dataTypeButton);
        HiddenHelper.hide((Element)this.listItems);
    }

    @Override
    public void showReadOnlyMessage(boolean show) {
        if (show) {
            HiddenHelper.show((Element)this.readOnlyMessage);
        } else {
            HiddenHelper.hide((Element)this.readOnlyMessage);
        }
    }

    public HTMLDivElement getListItems() {
        return this.listItems;
    }

    @Override
    public void showImportDataObjectButton() {
        HiddenHelper.show((Element)this.importDataObjectButton);
    }

    @Override
    public void hideImportDataObjectButton() {
        HiddenHelper.hide((Element)this.importDataObjectButton);
    }
}

