/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time;

import com.google.gwt.event.dom.client.BlurEvent;
import elemental2.dom.Event;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.Node;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.ConstraintPlaceholderHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time.DateTimeSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time.DateTimeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.TimeSelector;

@Templated
@Dependent
public class DateTimeSelectorView
implements DateTimeSelector.View {
    @DataField(value="date-selector-container")
    private final HTMLDivElement dateSelectorContainer;
    @DataField(value="time-selector-container")
    private final HTMLDivElement timeSelectorContainer;
    private final DateSelector dateSelector;
    private final TimeSelector timeSelector;
    private final ConstraintPlaceholderHelper placeholderHelper;
    private DateTimeSelector presenter;
    private Consumer<BlurEvent> onValueInputBlur;

    @Inject
    public DateTimeSelectorView(HTMLDivElement dateSelectorContainer, HTMLDivElement timeSelectorContainer, DateSelector dateSelector, TimeSelector timeSelector, ConstraintPlaceholderHelper placeholderHelper) {
        this.dateSelectorContainer = dateSelectorContainer;
        this.timeSelectorContainer = timeSelectorContainer;
        this.dateSelector = dateSelector;
        this.timeSelector = timeSelector;
        this.placeholderHelper = placeholderHelper;
    }

    @PostConstruct
    void init() {
        this.dateSelectorContainer.appendChild((Node)this.dateSelector.getElement());
        this.timeSelectorContainer.appendChild((Node)this.timeSelector.getElement());
        this.dateSelector.setOnInputBlurCallback(this::onBlurCallback);
        this.timeSelector.setOnInputBlurCallback(this::onBlurCallback);
        this.dateSelector.setPlaceholder(this.placeholderHelper.getPlaceholderSample(BuiltInType.DATE.toString()));
        this.timeSelector.setPlaceholder(this.placeholderHelper.getPlaceholderSample(BuiltInType.TIME.toString()));
    }

    void onBlurCallback(BlurEvent blurEvent) {
        Object eventTarget;
        if (!(Objects.isNull(this.getOnValueInputBlur()) || Objects.isNull(eventTarget = this.getEventTarget(blurEvent)) || this.dateSelector.isChild(eventTarget) || this.timeSelector.isChild(eventTarget))) {
            this.getOnValueInputBlur().accept(blurEvent);
        }
    }

    Consumer<BlurEvent> getOnValueInputBlur() {
        return this.onValueInputBlur;
    }

    Object getEventTarget(BlurEvent blurEvent) {
        return blurEvent.getNativeEvent().getRelatedEventTarget();
    }

    @Override
    public DateTimeValue getValue() {
        String dateValue = this.dateSelector.getValue();
        String timeValue = this.timeSelector.getValue();
        DateTimeValue dateTimeValue = new DateTimeValue();
        dateTimeValue.setDate(dateValue);
        dateTimeValue.setTime(timeValue);
        return dateTimeValue;
    }

    @Override
    public void setValue(DateTimeValue value) {
        this.dateSelector.setValue(value.getDate());
        this.timeSelector.setValue(value.getTime());
    }

    @Override
    public void setOnValueChanged(Consumer<Event> onValueChanged) {
        this.dateSelector.setOnInputChangeCallback(onValueChanged);
        this.timeSelector.setOnInputChangeCallback(onValueChanged);
    }

    @Override
    public void setOnValueInputBlur(Consumer<BlurEvent> blurEvent) {
        this.onValueInputBlur = blurEvent;
    }

    @Override
    public void select() {
        this.dateSelector.select();
    }

    public void init(DateTimeSelector presenter) {
        this.presenter = presenter;
    }
}

