/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;

@Dependent
public class ItemDefinitionCreateHandler {
    private final ItemDefinitionUtils itemDefinitionUtils;
    private final ItemDefinitionStore itemDefinitionStore;

    @Inject
    public ItemDefinitionCreateHandler(ItemDefinitionUtils itemDefinitionUtils, ItemDefinitionStore itemDefinitionStore) {
        this.itemDefinitionUtils = itemDefinitionUtils;
        this.itemDefinitionStore = itemDefinitionStore;
    }

    public ItemDefinition appendItemDefinition() {
        ItemDefinition itemDefinition = new ItemDefinition();
        this.itemDefinitions().add(itemDefinition);
        return itemDefinition;
    }

    public ItemDefinition insertNested(DataType record, DataType reference) {
        List itemComponent;
        ItemDefinition itemDefinition = this.getItemDefinition(record);
        ItemDefinition relativeParent = this.getIndexedItemDefinition(reference.getUUID());
        Optional<ItemDefinition> absoluteParent = this.lookupAbsoluteParent(reference.getUUID());
        if (absoluteParent.isPresent()) {
            itemComponent = absoluteParent.get().getItemComponent();
        } else {
            itemComponent = relativeParent.getItemComponent();
            relativeParent.setTypeRef(null);
        }
        itemComponent.add(0, itemDefinition);
        return itemDefinition;
    }

    public ItemDefinition insertSibling(DataType record, DataType reference, CreationType creationType) {
        ItemDefinition itemDefinition = this.getItemDefinition(record);
        ItemDefinition itemDefinitionReference = this.getIndexedItemDefinition(reference.getUUID());
        List<ItemDefinition> siblings = this.getItemDefinitionSiblings(reference);
        siblings.add(siblings.indexOf(itemDefinitionReference) + creationType.getIndexIncrement(), itemDefinition);
        return itemDefinition;
    }

    List<ItemDefinition> getItemDefinitionSiblings(DataType reference) {
        Optional<ItemDefinition> parent = this.lookupAbsoluteParent(reference.getParentUUID());
        if (parent.isPresent()) {
            return parent.get().getItemComponent();
        }
        return this.itemDefinitions();
    }

    Optional<ItemDefinition> lookupAbsoluteParent(String parentUUID) {
        Optional<ItemDefinition> optionalParent = Optional.ofNullable(this.getIndexedItemDefinition(parentUUID));
        if (optionalParent.isPresent()) {
            boolean isStructure;
            ItemDefinition parent = optionalParent.get();
            boolean bl = isStructure = parent.getTypeRef() == null;
            if (isStructure) {
                return Optional.of(parent);
            }
            return this.findItemDefinitionByName(parent.getTypeRef().getLocalPart());
        }
        return Optional.empty();
    }

    private Optional<ItemDefinition> findItemDefinitionByName(String type) {
        return this.itemDefinitionUtils.findByName(type);
    }

    private List<ItemDefinition> itemDefinitions() {
        return this.itemDefinitionUtils.all();
    }

    private ItemDefinition getIndexedItemDefinition(String uuid) {
        return this.itemDefinitionStore.get(uuid);
    }

    private ItemDefinition getItemDefinition(DataType dataType) {
        return Optional.ofNullable(this.getIndexedItemDefinition(dataType.getUUID())).orElse(new ItemDefinition());
    }
}

