/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.marshaller.converters.IdPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.QNamePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITNamedElement;

public class InformationItemPrimaryPropertyConverter {
    private static final String DEFAULT_NAME = "";

    public static InformationItemPrimary wbFromDMN(JSITInformationItem dmn, Object parent) {
        if (Objects.isNull(dmn)) {
            return null;
        }
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Name name = new Name(InformationItemPrimaryPropertyConverter.getParentName(parent));
        QName typeRef = QNamePropertyConverter.wbFromDMN(dmn.getTypeRef());
        return new InformationItemPrimary(id, name, typeRef);
    }

    public static JSITInformationItem dmnFromWB(InformationItemPrimary wb, DMNModelInstrumentedBase parent) {
        if (Objects.isNull(wb)) {
            return null;
        }
        JSITInformationItem result = new JSITInformationItem();
        result.setId(wb.getId().getValue());
        result.setName(InformationItemPrimaryPropertyConverter.getParentName(parent));
        QName typeRef = wb.getTypeRef();
        QNamePropertyConverter.setDMNfromWB(typeRef, arg_0 -> ((JSITInformationItem)result).setTypeRef(arg_0));
        return result;
    }

    private static String getParentName(Object parent) {
        if (JSITNamedElement.instanceOf((Object)parent)) {
            JSITNamedElement namedElement = (JSITNamedElement)parent;
            Optional<String> name = Optional.ofNullable(namedElement.getName());
            return name.orElse(DEFAULT_NAME);
        }
        return DEFAULT_NAME;
    }

    private static String getParentName(DMNModelInstrumentedBase parent) {
        if (parent instanceof HasName) {
            HasName hasName = (HasName)parent;
            Optional<Name> name = Optional.ofNullable(hasName.getName());
            return name.map(Name::getValue).orElse(DEFAULT_NAME);
        }
        return DEFAULT_NAME;
    }
}

