/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.session;

import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

@Dependent
public class NodeTextSetter {
    private final TextPropertyProviderFactory textPropertyProviderFactory;
    private final Event<CanvasElementUpdatedEvent> canvasElementUpdatedEvent;
    private final DMNGraphUtils dmnGraphUtils;

    @Inject
    public NodeTextSetter(TextPropertyProviderFactory textPropertyProviderFactory, Event<CanvasElementUpdatedEvent> canvasElementUpdatedEvent, DMNGraphUtils dmnGraphUtils) {
        this.textPropertyProviderFactory = textPropertyProviderFactory;
        this.canvasElementUpdatedEvent = canvasElementUpdatedEvent;
        this.dmnGraphUtils = dmnGraphUtils;
    }

    public TextPropertyProviderFactory getTextPropertyProviderFactory() {
        return this.textPropertyProviderFactory;
    }

    public void setText(String newText, Node node) {
        String name = this.getName(node);
        if (!Objects.equals(name, newText)) {
            this.getCurrentSession().ifPresent(session -> {
                TextPropertyProvider textPropertyProvider = this.getTextPropertyProviderFactory().getProvider((Element)node);
                this.getCanvasHandler((DMNEditorSession)session).ifPresent(canvasHandler -> {
                    textPropertyProvider.setText(canvasHandler, session.getCommandManager(), (Element)node, newText);
                    this.fireCanvasElementUpdated((AbstractCanvasHandler)canvasHandler, node);
                });
            });
        }
    }

    void fireCanvasElementUpdated(AbstractCanvasHandler canvasHandler, Node node) {
        this.canvasElementUpdatedEvent.fire((Object)new CanvasElementUpdatedEvent((CanvasHandler)canvasHandler, (Element)node));
    }

    String getName(Object node) {
        return this.getNamedElement(node).map(namedElement -> namedElement.getName().getValue()).orElse("");
    }

    Optional<NamedElement> getNamedElement(Object node) {
        return Optional.ofNullable(node).filter(obj -> obj instanceof Node).map(obj -> (Node)obj).map(Element::getContent).filter(content -> content instanceof View).map(content -> (View)content).map(Definition::getDefinition).filter(content -> content instanceof NamedElement).map(content -> (NamedElement)content);
    }

    Optional<DMNEditorSession> getCurrentSession() {
        return this.dmnGraphUtils.getCurrentSession().map(s -> (DMNEditorSession)s);
    }

    Optional<AbstractCanvasHandler> getCanvasHandler(DMNEditorSession session) {
        return Optional.ofNullable(session.getCanvasHandler());
    }
}

