/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion.feel;

import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.kie.dmn.feel.gwt.functions.api.FunctionOverrideVariation;
import org.kie.dmn.feel.gwt.functions.client.FEELFunctionProvider;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.FEELLanguageService;

@ApplicationScoped
public class TypeStackUtils {
    public final List<String> ALLOWED_TYPE_NAMES = Arrays.stream(BuiltInType.values()).flatMap(builtInType -> Arrays.stream(builtInType.getNames())).collect(Collectors.toList());
    private final Map<String, Type> typeByFunctionName = new HashMap<String, Type>();

    public List<Type> getTypeStack(ASTNode node, FEELLanguageService.Position position) {
        return this.getTypeStack(node, null, position, false, false);
    }

    private List<Type> getTypeStack(ASTNode currentNode, ASTNode nextNode, FEELLanguageService.Position position, boolean isListOfParameters, boolean isParentEligible) {
        boolean isEligibleType;
        ArrayList<Type> typeStack = new ArrayList<Type>();
        if (currentNode == null) {
            return typeStack;
        }
        Type type = this.getType(currentNode);
        boolean isNextListOfParameters = currentNode instanceof FunctionInvocationNode;
        boolean bl = isEligibleType = this.isEligibleType(currentNode, nextNode, position, isParentEligible) && !isListOfParameters;
        if (isEligibleType) {
            typeStack.add(type);
        }
        try {
            this.forEach(this.getChildren(currentNode), (current, next) -> {
                boolean isParentEligibleType = isListOfParameters ? isParentEligible : isEligibleType;
                typeStack.addAll(this.getTypeStack((ASTNode)current, (ASTNode)next, position, isNextListOfParameters, isParentEligibleType));
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typeStack;
    }

    public Type getType(ASTNode astNode) {
        if (astNode instanceof FunctionInvocationNode) {
            String[] split = astNode.getText().split("\\(");
            return this.getTypeByFunctionName().get(split[0]);
        }
        return astNode.getResultType();
    }

    private Map<String, Type> getTypeByFunctionName() {
        if (this.typeByFunctionName.isEmpty()) {
            for (FunctionOverrideVariation definition : this.getFunctionOverrideVariations()) {
                this.typeByFunctionName.put(definition.getFunctionName(), definition.getReturnType());
            }
        }
        return this.typeByFunctionName;
    }

    private List<FunctionOverrideVariation> getFunctionOverrideVariations() {
        FEELFunctionProvider functionProvider = (FEELFunctionProvider)GWT.create(FEELFunctionProvider.class);
        return functionProvider.getDefinitions();
    }

    private boolean isEligibleType(ASTNode node, ASTNode next, FEELLanguageService.Position position, boolean isParentEligibleType) {
        boolean isAllowedType = this.isAllowedType(node);
        boolean isEligibleLine = this.isEligibleLine(node, position.line);
        boolean isEligibleColumn = this.isEligibleColumn(node, next, position.column, isParentEligibleType);
        return isAllowedType && isEligibleLine && isEligibleColumn;
    }

    private boolean isAllowedType(ASTNode node) {
        return this.ALLOWED_TYPE_NAMES.contains(this.getType(node).getName());
    }

    private boolean isEligibleLine(ASTNode node, int line) {
        int stop = node.getEndLine();
        int start = node.getStartLine();
        return line >= start && line <= stop;
    }

    private boolean isEligibleColumn(ASTNode node, ASTNode next, int column, boolean isParentEligibleType) {
        return this.isEligibleColumnStart(node, column) && this.isEligibleColumnEnd(node, next, column, isParentEligibleType);
    }

    private boolean isEligibleColumnEnd(ASTNode node, ASTNode next, int column, boolean isParentEligibleType) {
        boolean hasNextNode = next != null;
        int startNextNodeColumn = hasNextNode ? next.getStartColumn() : 0;
        int endNodeColumn = node.getEndColumn() + this.countExtraChar(node);
        boolean hasGapBetweenNodes = startNextNodeColumn - endNodeColumn > 0;
        int stop = hasGapBetweenNodes ? startNextNodeColumn : endNodeColumn;
        return column <= stop || !isParentEligibleType && !hasNextNode;
    }

    private boolean isEligibleColumnStart(ASTNode node, int column) {
        int startNodeColumn = node.getStartColumn();
        boolean isMultiline = node.getEndLine() > node.getStartLine();
        int start = isMultiline ? 0 : startNodeColumn;
        return column >= start;
    }

    private int countExtraChar(ASTNode node) {
        Type resultType = this.getType(node);
        if (resultType.conformsTo((Type)BuiltInType.LIST) || resultType.conformsTo((Type)BuiltInType.RANGE)) {
            return 1;
        }
        return 0;
    }

    private Iterator<ASTNode> getChildren(ASTNode currentNode) {
        return Arrays.stream(currentNode.getChildrenNode()).iterator();
    }

    private void forEach(Iterator<ASTNode> iterator, BiConsumer<ASTNode, ASTNode> consumer) {
        if (!iterator.hasNext()) {
            return;
        }
        ASTNode current = iterator.next();
        while (iterator.hasNext()) {
            ASTNode next = iterator.next();
            consumer.accept(current, next);
            current = next;
        }
        consumer.accept(current, null);
    }
}

