/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.panel;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelCellSelectionHandler;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class DMNGridPanelCellSelectionHandlerImpl
implements DMNGridPanelCellSelectionHandler {
    private final DMNGridLayer gridLayer;

    public DMNGridPanelCellSelectionHandlerImpl(DMNGridLayer gridLayer) {
        this.gridLayer = gridLayer;
    }

    @Override
    public void selectHeaderCellIfRequired(int uiHeaderRowIndex, int uiHeaderColumnIndex, GridWidget gridWidget, boolean isShiftKeyDown, boolean isControlKeyDown) {
        GridData gridData = gridWidget.getModel();
        GridColumn column = (GridColumn)gridData.getColumns().get(uiHeaderColumnIndex);
        this.doSelectCellIfRequired(uiHeaderRowIndex, column.getIndex(), gridWidget, gridData.getSelectedHeaderCells(), () -> gridWidget.selectHeaderCell(uiHeaderRowIndex, uiHeaderColumnIndex, isShiftKeyDown, isControlKeyDown));
    }

    @Override
    public void selectCellIfRequired(int uiRowIndex, int uiColumnIndex, GridWidget gridWidget, boolean isShiftKeyDown, boolean isControlKeyDown) {
        GridData gridData = gridWidget.getModel();
        GridColumn column = (GridColumn)gridData.getColumns().get(uiColumnIndex);
        this.doSelectCellIfRequired(uiRowIndex, column.getIndex(), gridWidget, gridData.getSelectedCells(), () -> gridWidget.selectCell(uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown));
    }

    private void doSelectCellIfRequired(int uiRowIndex, int uiColumnIndex, GridWidget gridWidget, List<GridData.SelectedCell> selectedCells, Supplier<Boolean> isSelectionChanged) {
        Stream<GridData.SelectedCell> modelColumnSelectedCells = selectedCells.stream().filter(sc -> sc.getColumnIndex() == uiColumnIndex);
        boolean isContextMenuCellSelectedCell = modelColumnSelectedCells.map(GridData.SelectedCell::getRowIndex).anyMatch(ri -> ri == uiRowIndex);
        if (!isContextMenuCellSelectedCell) {
            this.gridLayer.select(gridWidget);
            if (isSelectionChanged.get().booleanValue()) {
                this.gridLayer.batch();
            }
        }
    }
}

