/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.toolbar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.layout.GraphProcessor;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@DMNEditor
public class DMNGraphProcessor
implements GraphProcessor {
    private final HashMap<String, String> replacedNodes = new HashMap();

    public Iterable<? extends Node> getNodes(Graph<?, ?> graph) {
        ArrayList nodes = new ArrayList();
        graph.nodes().forEach(nodes::add);
        for (Node n : graph.nodes()) {
            Definition def = (Definition)n.getContent();
            if (!(def.getDefinition() instanceof DecisionService)) continue;
            List<Node> childNodes = this.getChildNodes(n);
            nodes.removeAll(childNodes);
            for (Node o : childNodes) {
                this.replacedNodes.put(o.getUUID(), n.getUUID());
            }
        }
        return nodes;
    }

    protected List<Node> getChildNodes(Node node) {
        return GraphUtils.getChildNodes((Node)node);
    }

    public boolean isReplacedByAnotherNode(String uuid) {
        return this.replacedNodes.containsKey(uuid);
    }

    public String getReplaceNodeId(String uuid) {
        return this.replacedNodes.get(uuid);
    }
}

