/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClause;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClauseText;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class DeleteRuleAnnotationClauseCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final DecisionTable decisionTable;
    private final GridData uiModel;
    private final int uiColumnIndex;
    private final DecisionTableUIModelMapper uiModelMapper;
    private final Command executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final RuleAnnotationClause oldRuleClause;
    private final List<RuleAnnotationClauseText> oldColumnData;
    private final GridColumn<?> oldUiModelColumn;

    public DeleteRuleAnnotationClauseCommand(DecisionTable decisionTable, GridData uiModel, int uiColumnIndex, DecisionTableUIModelMapper uiModelMapper, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.decisionTable = decisionTable;
        this.uiModel = uiModel;
        this.uiColumnIndex = uiColumnIndex;
        this.uiModelMapper = uiModelMapper;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.oldRuleClause = (RuleAnnotationClause)decisionTable.getAnnotations().get(this.getRuleAnnotationClauseIndex());
        this.oldColumnData = this.extractColumnData();
        this.oldUiModelColumn = (GridColumn)uiModel.getColumns().get(uiColumnIndex);
    }

    Command getUndoCanvasOperation() {
        return this.undoCanvasOperation;
    }

    DecisionTableUIModelMapper getUiModelMapper() {
        return this.uiModelMapper;
    }

    Command getExecuteCanvasOperation() {
        return this.executeCanvasOperation;
    }

    DecisionTable getDecisionTable() {
        return this.decisionTable;
    }

    int getUiColumnIndex() {
        return this.uiColumnIndex;
    }

    GridData getUiModel() {
        return this.uiModel;
    }

    List<RuleAnnotationClauseText> extractColumnData() {
        int clauseIndex = this.getRuleAnnotationClauseIndex();
        return this.getDecisionTable().getRule().stream().map(row -> (RuleAnnotationClauseText)row.getAnnotationEntry().get(clauseIndex)).collect(Collectors.toList());
    }

    int getRuleAnnotationClauseIndex() {
        return this.getUiColumnIndex() - 1 - this.getDecisionTable().getInput().size() - this.getDecisionTable().getOutput().size();
    }

    RuleAnnotationClause getOldRuleClause() {
        return this.oldRuleClause;
    }

    List<RuleAnnotationClauseText> getOldColumnData() {
        return this.oldColumnData;
    }

    GridColumn<?> getOldUiModelColumn() {
        return this.oldUiModelColumn;
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                DeleteRuleAnnotationClauseCommand.this.getDecisionTable().getComponentWidths().remove(DeleteRuleAnnotationClauseCommand.this.getUiColumnIndex());
                int clauseIndex = DeleteRuleAnnotationClauseCommand.this.getRuleAnnotationClauseIndex();
                DeleteRuleAnnotationClauseCommand.this.getDecisionTable().getRule().forEach(row -> row.getAnnotationEntry().remove(clauseIndex));
                DeleteRuleAnnotationClauseCommand.this.getDecisionTable().getAnnotations().remove(clauseIndex);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                DeleteRuleAnnotationClauseCommand.this.getDecisionTable().getComponentWidths().add(DeleteRuleAnnotationClauseCommand.this.getUiColumnIndex(), DeleteRuleAnnotationClauseCommand.this.getOldUiModelColumn().getWidth());
                int clauseIndex = DeleteRuleAnnotationClauseCommand.this.getRuleAnnotationClauseIndex();
                DeleteRuleAnnotationClauseCommand.this.getDecisionTable().getAnnotations().add(clauseIndex, DeleteRuleAnnotationClauseCommand.this.getOldRuleClause());
                IntStream.range(0, DeleteRuleAnnotationClauseCommand.this.getDecisionTable().getRule().size()).forEach(rowIndex -> {
                    RuleAnnotationClauseText value = DeleteRuleAnnotationClauseCommand.this.getOldColumnData().get(rowIndex);
                    ((DecisionRule)DeleteRuleAnnotationClauseCommand.this.getDecisionTable().getRule().get(rowIndex)).getAnnotationEntry().add(clauseIndex, value);
                });
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                GridColumn gridColumn = (GridColumn)DeleteRuleAnnotationClauseCommand.this.getUiModel().getColumns().get(DeleteRuleAnnotationClauseCommand.this.getUiColumnIndex());
                DeleteRuleAnnotationClauseCommand.this.getUiModel().deleteColumn(gridColumn);
                DeleteRuleAnnotationClauseCommand.this.updateParentInformation();
                DeleteRuleAnnotationClauseCommand.this.getExecuteCanvasOperation().execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                DeleteRuleAnnotationClauseCommand.this.getUiModel().insertColumn(DeleteRuleAnnotationClauseCommand.this.getUiColumnIndex(), DeleteRuleAnnotationClauseCommand.this.getOldUiModelColumn());
                for (int rowIndex = 0; rowIndex < DeleteRuleAnnotationClauseCommand.this.getDecisionTable().getRule().size(); ++rowIndex) {
                    DeleteRuleAnnotationClauseCommand.this.getUiModelMapper().fromDMNModel(rowIndex, DeleteRuleAnnotationClauseCommand.this.getUiColumnIndex());
                }
                DeleteRuleAnnotationClauseCommand.this.updateParentInformation();
                DeleteRuleAnnotationClauseCommand.this.getUndoCanvasOperation().execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

