/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.factories;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.common.BoxedExpressionHelper;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemBuilder;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.Command;

@Dependent
public class DecisionNavigatorNestedItemFactory {
    private static final Map<Class<? extends Expression>, DecisionNavigatorItem.Type> ITEM_TYPE_BY_EXPRESSION = new Maps.Builder().put(Context.class, (Object)DecisionNavigatorItem.Type.CONTEXT).put(DecisionTable.class, (Object)DecisionNavigatorItem.Type.DECISION_TABLE).put(FunctionDefinition.class, (Object)DecisionNavigatorItem.Type.FUNCTION_DEFINITION).put(Invocation.class, (Object)DecisionNavigatorItem.Type.INVOCATION).put(List.class, (Object)DecisionNavigatorItem.Type.LIST).put(LiteralExpression.class, (Object)DecisionNavigatorItem.Type.LITERAL_EXPRESSION).put(Relation.class, (Object)DecisionNavigatorItem.Type.RELATION).build();
    private final SessionManager sessionManager;
    private final Event<EditExpressionEvent> editExpressionEvent;
    private final DMNGraphUtils dmnGraphUtils;
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final Event<CanvasSelectionEvent> canvasSelectionEvent;
    private final BoxedExpressionHelper helper;
    private final ReadOnlyProvider readOnlyProvider;

    @Inject
    public DecisionNavigatorNestedItemFactory(SessionManager sessionManager, Event<EditExpressionEvent> editExpressionEvent, DMNGraphUtils dmnGraphUtils, @DMNEditor Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, Event<CanvasSelectionEvent> canvasSelectionEvent, BoxedExpressionHelper helper, ReadOnlyProvider readOnlyProvider) {
        this.sessionManager = sessionManager;
        this.editExpressionEvent = editExpressionEvent;
        this.dmnGraphUtils = dmnGraphUtils;
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.canvasSelectionEvent = canvasSelectionEvent;
        this.helper = helper;
        this.readOnlyProvider = readOnlyProvider;
    }

    public DecisionNavigatorItem makeItem(Node<View, Edge> node) {
        String uuid = this.getUUID(node);
        DecisionNavigatorItem.Type type = this.getType(node);
        String label = this.getLabel(node);
        String parentUUID = node.getUUID();
        Command onClick = this.makeOnClickCommand(node, parentUUID);
        return this.navigatorItemBuilder().withUUID(uuid).withLabel(label).withType(type).withOnClick(onClick).withParentUUID(parentUUID).build();
    }

    public boolean hasNestedElement(Node<View, Edge> node) {
        return this.helper.getOptionalHasExpression(node).isPresent() && this.helper.getOptionalExpression(node).isPresent();
    }

    Command makeOnClickCommand(Node<View, Edge> node, String uuid) {
        return () -> {
            CanvasHandler canvas = this.dmnGraphUtils.getCanvasHandler();
            this.canvasSelectionEvent.fire((Object)this.makeCanvasSelectionEvent(canvas, uuid));
            this.editExpressionEvent.fire((Object)this.makeEditExpressionEvent(node));
        };
    }

    CanvasSelectionEvent makeCanvasSelectionEvent(CanvasHandler canvas, String uuid) {
        return new CanvasSelectionEvent(canvas, uuid);
    }

    EditExpressionEvent makeEditExpressionEvent(Node<View, Edge> node) {
        ClientSession currentSession = this.sessionManager.getCurrentSession();
        Object definition = DefinitionUtils.getElementDefinition(node);
        HasExpression hasExpression = this.helper.getHasExpression(node);
        Optional<HasName> hasName = Optional.of((HasName)definition);
        boolean isOnlyVisualChangeAllowed = this.isOnlyVisualChangeAllowed(definition) || this.readOnlyProvider.isReadOnlyDiagram();
        return new EditExpressionEvent(currentSession, node.getUUID(), hasExpression, hasName, isOnlyVisualChangeAllowed);
    }

    private boolean isOnlyVisualChangeAllowed(Object definition) {
        if (definition instanceof DRGElement) {
            return ((DRGElement)definition).isAllowOnlyVisualChange();
        }
        return false;
    }

    String getUUID(Node<View, Edge> node) {
        Expression expression = this.getExpression(node);
        return expression.getId().getValue();
    }

    String getLabel(Node<View, Edge> node) {
        Optional<Expression> expression = Optional.of(this.getExpression(node));
        return this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(expression).get().getName();
    }

    DecisionNavigatorItem.Type getType(Node<View, Edge> node) {
        return ITEM_TYPE_BY_EXPRESSION.get(this.getExpression(node).getClass());
    }

    private Expression getExpression(Node<View, Edge> node) {
        return this.helper.getExpression(node);
    }

    private DecisionNavigatorItemBuilder navigatorItemBuilder() {
        return new DecisionNavigatorItemBuilder();
    }
}

