/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.included.components;

import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;

@Dependent
@Templated
public class DecisionComponentsView
implements DecisionComponents.View {
    @DataField(value="drg-element-filter")
    private final HTMLSelectElement drgElementFilter;
    @DataField(value="term-filter")
    private final HTMLInputElement termFilter;
    @DataField(value="list")
    private final HTMLDivElement list;
    @DataField(value="empty-state")
    private final HTMLDivElement emptyState;
    @DataField(value="loading")
    private final HTMLDivElement loading;
    @DataField(value="components-counter")
    private final HTMLDivElement componentsCounter;
    private final TranslationService translationService;
    private DecisionComponents presenter;

    @Inject
    public DecisionComponentsView(HTMLSelectElement drgElementFilter, HTMLInputElement termFilter, HTMLDivElement list, HTMLDivElement emptyState, HTMLDivElement loading, HTMLDivElement componentsCounter, TranslationService translationService) {
        this.drgElementFilter = drgElementFilter;
        this.termFilter = termFilter;
        this.list = list;
        this.emptyState = emptyState;
        this.loading = loading;
        this.componentsCounter = componentsCounter;
        this.translationService = translationService;
    }

    @PostConstruct
    public void init() {
        this.getDrgElementFilter().selectpicker("refresh");
        this.getDrgElementFilter().on("hidden.bs.select", this.onDrgElementFilterChange());
        this.setupTermFilterPlaceholder();
    }

    public void init(DecisionComponents presenter) {
        this.presenter = presenter;
    }

    private void setupTermFilterPlaceholder() {
        this.termFilter.placeholder = this.translationService.format("DecisionComponentsView.EnterText", new Object[0]);
    }

    @EventHandler(value={"term-filter"})
    public void onTermFilterChange(KeyUpEvent e) {
        this.presenter.applyTermFilter(this.termFilter.value);
    }

    JQuerySelectPicker.CallbackFunction onDrgElementFilterChange() {
        return event -> this.presenter.applyDrgElementFilterFilter(event.target.value);
    }

    @Override
    public void clear() {
        RemoveHelper.removeChildren((Element)this.list);
        HiddenHelper.hide((Element)this.emptyState);
    }

    @Override
    public void addListItem(HTMLElement htmlElement) {
        this.list.appendChild((Node)htmlElement);
    }

    @Override
    public void showEmptyState() {
        HiddenHelper.show((Element)this.emptyState);
    }

    @Override
    public void showLoading() {
        HiddenHelper.show((Element)this.loading);
    }

    @Override
    public void hideLoading() {
        HiddenHelper.hide((Element)this.loading);
    }

    @Override
    public void disableFilterInputs() {
        this.termFilter.value = "";
        this.getDrgElementFilter().selectpicker("val", "");
        this.disableFilterInputs(true);
    }

    @Override
    public void enableFilterInputs() {
        this.disableFilterInputs(false);
    }

    @Override
    public void setComponentsCounter(Integer count) {
        this.componentsCounter.textContent = count.toString();
    }

    private void disableFilterInputs(boolean disabled) {
        this.termFilter.disabled = disabled;
        this.drgElementFilter.disabled = disabled;
        this.getDrgElementFilter().selectpicker("refresh");
    }

    JQuerySelectPicker getDrgElementFilter() {
        return JQuerySelectPicker.$((Element)this.drgElementFilter);
    }
}

