/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class DecisionNavigatorTreePresenter {
    private final View view;
    private final Map<String, DecisionNavigatorItem> indexedItems = new HashMap<String, DecisionNavigatorItem>();
    private String activeParentUUID;

    @Inject
    public DecisionNavigatorTreePresenter(View view) {
        this.view = view;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void setupItems(List<DecisionNavigatorItem> items) {
        this.getIndexedItems().clear();
        this.index(items);
        this.view.clean();
        this.view.setup(items);
    }

    public void removeAllItems() {
        this.view.clean();
        this.getIndexedItems().clear();
    }

    public DecisionNavigatorItem getActiveParent() {
        return this.getIndexedItems().get(this.activeParentUUID);
    }

    public void setActiveParentUUID(String activeParentUUID) {
        this.activeParentUUID = activeParentUUID;
    }

    public void selectItem(String uuid) {
        this.view.select(uuid);
    }

    public void deselectItem() {
        this.view.deselect();
    }

    void index(Collection<DecisionNavigatorItem> items) {
        items.forEach(this::index);
    }

    void index(DecisionNavigatorItem item) {
        this.getIndexedItems().put(item.getUUID(), item);
        this.index(item.getChildren());
    }

    Map<String, DecisionNavigatorItem> getIndexedItems() {
        return this.indexedItems;
    }

    public static interface View
    extends UberElemental<DecisionNavigatorTreePresenter> {
        public void clean();

        public void setup(List<DecisionNavigatorItem> var1);

        public void select(String var1);

        public void deselect();
    }
}

