/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.common.persistence;

import java.util.List;
import java.util.Optional;
import org.kie.workbench.common.dmn.client.editors.common.persistence.RecordEngine;

public abstract class ActiveRecord<T> {
    private RecordEngine<T> recordEngine;

    public ActiveRecord(RecordEngine<T> recordEngine) {
        this.recordEngine = recordEngine;
    }

    public List<T> update() {
        return this.getRecordEngine().update(this.getRecord());
    }

    public List<T> destroy() {
        return this.getRecordEngine().destroy(this.getRecord());
    }

    public List<T> create() {
        return this.getRecordEngine().create(this.getRecord());
    }

    public boolean isValid() {
        return this.getRecordEngine().isValid(this.getRecord());
    }

    public RecordEngine<T> getRecordEngine() {
        return this.getOptionalRecordEngine().orElseThrow(this::error);
    }

    public boolean isRecordEnginePresent() {
        return this.getOptionalRecordEngine().isPresent();
    }

    private Optional<RecordEngine<T>> getOptionalRecordEngine() {
        return Optional.ofNullable(this.recordEngine);
    }

    protected abstract T getRecord();

    private UnsupportedOperationException error() {
        String errorMessage = "'ActiveRecord' operations are not supported. Please provide a record engine.";
        return new UnsupportedOperationException("'ActiveRecord' operations are not supported. Please provide a record engine.");
    }
}

