/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.list;

import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.expressions.types.list.AddListRowCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.list.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.list.DeleteListRowCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridRowNumberColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListUIModelMapperHelper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.util.SelectionUtils;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGridRenderer;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridWidgetRegistry;

public class ListGrid
extends BaseExpressionGrid<org.kie.workbench.common.dmn.api.definition.model.List, ListGridData, ListUIModelMapper>
implements HasListSelectorControl {
    private final ValueAndDataTypePopoverView.Presenter headerEditor;
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;

    public ListGrid(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, ListGridData gridData, DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DefaultCanvasCommandFactory canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, ListSelectorView.Presenter listSelector, TranslationService translationService, boolean isOnlyVisualChangeAllowed, int nesting, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, ValueAndDataTypePopoverView.Presenter headerEditor, ReadOnlyProvider readOnlyProvider) {
        super(parent, nodeUUID, hasExpression, hasName, gridPanel, gridLayer, gridData, (GridRenderer)new BaseExpressionGridRenderer(gridData), definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, refreshFormPropertiesEvent, domainObjectSelectionEvent, cellEditorControls, listSelector, translationService, isOnlyVisualChangeAllowed, nesting, readOnlyProvider);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.headerEditor = headerEditor;
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
        super.doInitialisation();
    }

    @Override
    protected void doInitialisation() {
    }

    @Override
    public ListUIModelMapper makeUiModelMapper() {
        return new ListUIModelMapper((GridWidget)this, () -> ((ListGrid)this).getModel(), this.getExpression(), () -> this.isOnlyVisualChangeAllowed, this.expressionEditorDefinitionsSupplier, this.listSelector, this.nesting);
    }

    @Override
    public void initialiseUiColumns() {
        ContextGridRowNumberColumn rowNumberColumn = new ContextGridRowNumberColumn(Collections.emptyList(), this.getAndSetInitialWidth(0, 50.0));
        ListExpressionEditorColumn listColumn = new ListExpressionEditorColumn((GridWidgetRegistry)this.gridLayer, this.getAndSetInitialWidth(1, 200.0), this);
        this.model.appendColumn((GridColumn)rowNumberColumn);
        this.model.appendColumn((GridColumn)listColumn);
        this.getRenderer().setColumnRenderConstraint((isSelectionLayer, gridColumn) -> true);
    }

    @Override
    public void initialiseUiRows() {
        this.getExpression().get().ifPresent(list -> list.getExpression().forEach(e -> this.model.appendRow((GridRow)new ExpressionEditorGridRow())));
    }

    @Override
    public void initialiseUiCells() {
        this.getExpression().get().ifPresent(list -> {
            for (int rowIndex = 0; rowIndex < list.getExpression().size(); ++rowIndex) {
                ((ListUIModelMapper)this.uiModelMapper).fromDMNModel(rowIndex, 0);
                ((ListUIModelMapper)this.uiModelMapper).fromDMNModel(rowIndex, 1);
            }
        });
    }

    @Override
    public List<HasListSelectorControl.ListSelectorItem> getItems(int uiRowIndex, int uiColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        boolean isMultiRow = SelectionUtils.isMultiRow(this.model);
        boolean isMultiSelect = SelectionUtils.isMultiSelect(this.model);
        items.add(HasListSelectorControl.ListSelectorHeaderItem.build(this.translationService.format("ListEditor.HeaderRows", new Object[0])));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ListEditor.InsertRowAbove", new Object[0]), !isMultiRow, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addRow(uiRowIndex));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ListEditor.InsertRowBelow", new Object[0]), !isMultiRow, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addRow(uiRowIndex + 1));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ListEditor.DeleteRow", new Object[0]), !isMultiRow && this.model.getRowCount() > 1, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.deleteRow(uiRowIndex));
        }));
        if (ListUIModelMapperHelper.getSection(uiColumnIndex) != ListUIModelMapperHelper.ListSection.EXPRESSION) {
            return items;
        }
        GridCell cell = this.model.getCell(uiRowIndex, uiColumnIndex);
        ExpressionCellValue ecv = (ExpressionCellValue)cell.getValue();
        if (!((Optional)ecv.getValue()).isPresent()) {
            return items;
        }
        BaseExpressionGrid grid = (BaseExpressionGrid)((Optional)ecv.getValue()).get();
        if (grid instanceof UndefinedExpressionGrid) {
            return items;
        }
        if (items.size() > 0) {
            items.add(new HasListSelectorControl.ListSelectorDividerItem());
        }
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ExpressionEditor.Clear", new Object[0]), !isMultiSelect, () -> {
            this.cellEditorControls.hide();
            this.clearExpressionType(uiRowIndex);
        }));
        return items;
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        HasListSelectorControl.ListSelectorTextItem li = (HasListSelectorControl.ListSelectorTextItem)item;
        li.getCommand().execute();
    }

    void addRow(int index) {
        this.getExpression().get().ifPresent(list -> {
            ExpressionEditorGridRow listRow = new ExpressionEditorGridRow();
            HasExpression hasExpression = HasExpression.wrap((DMNModelInstrumentedBase)list, (Expression)new LiteralExpression());
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new AddListRowCommand((org.kie.workbench.common.dmn.api.definition.model.List)list, hasExpression, this.model, (GridRow)listRow, index, (ListUIModelMapper)this.uiModelMapper, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING)));
        });
    }

    void deleteRow(int index) {
        this.getExpression().get().ifPresent(list -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new DeleteListRowCommand((org.kie.workbench.common.dmn.api.definition.model.List)list, this.model, index, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING))));
    }

    void clearExpressionType(int uiRowIndex) {
        GridCellTuple gc = new GridCellTuple(uiRowIndex, 1, (GridWidget)this);
        this.getExpression().get().ifPresent(list -> {
            HasExpression hasExpression = (HasExpression)list.getExpression().get(uiRowIndex);
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new ClearExpressionTypeCommand(gc, hasExpression, (ListUIModelMapper)this.uiModelMapper, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(uiRowIndex, 1);
            }, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(uiRowIndex, 1);
            }));
        });
    }

    @Override
    public void doAfterSelectionChange(int uiRowIndex, int uiColumnIndex) {
        if (this.hasAnyHeaderCellSelected() || this.hasMultipleCellsSelected()) {
            super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
            return;
        }
        if (this.getExpression().get().isPresent()) {
            HasExpression hasExpression;
            Expression expression;
            org.kie.workbench.common.dmn.api.definition.model.List list = (org.kie.workbench.common.dmn.api.definition.model.List)this.getExpression().get().get();
            ListUIModelMapperHelper.ListSection section = ListUIModelMapperHelper.getSection(uiColumnIndex);
            if (section == ListUIModelMapperHelper.ListSection.EXPRESSION && (expression = (hasExpression = (HasExpression)list.getExpression().get(uiRowIndex)).getExpression()) instanceof DomainObject) {
                DomainObject domainObject = (DomainObject)expression;
                this.fireDomainObjectSelectionEvent(domainObject);
                return;
            }
        }
        super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
    }
}

