/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.list;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListUIModelMapperHelper;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

public class ListUIModelMapper
extends BaseUIModelMapper<List> {
    private final GridWidget gridWidget;
    private final Supplier<Boolean> isOnlyVisualChangeAllowedSupplier;
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final ListSelectorView.Presenter listSelector;
    private final int nesting;

    public ListUIModelMapper(GridWidget gridWidget, Supplier<GridData> uiModel, Supplier<Optional<List>> dmnModel, Supplier<Boolean> isOnlyVisualChangeAllowedSupplier, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, ListSelectorView.Presenter listSelector, int nesting) {
        super(uiModel, dmnModel);
        this.gridWidget = gridWidget;
        this.isOnlyVisualChangeAllowedSupplier = isOnlyVisualChangeAllowedSupplier;
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.listSelector = listSelector;
        this.nesting = nesting;
    }

    @Override
    public void fromDMNModel(int rowIndex, int columnIndex) {
        ((Optional)this.dmnModel.get()).ifPresent(list -> {
            ListUIModelMapperHelper.ListSection section = ListUIModelMapperHelper.getSection(columnIndex);
            switch (section) {
                case ROW_INDEX: {
                    ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, () -> new ContextGridCell(new BaseGridCellValue((Object)(rowIndex + 1)), this.listSelector));
                    ((GridData)this.uiModel.get()).getCell(rowIndex, columnIndex).setSelectionStrategy(RowSelectionStrategy.INSTANCE);
                    break;
                }
                case EXPRESSION: {
                    HasExpression hasExpression = (HasExpression)list.getExpression().get(rowIndex);
                    Optional<Expression> expression = Optional.ofNullable(hasExpression.getExpression());
                    boolean isOnlyVisualChangeAllowed = this.isOnlyVisualChangeAllowedSupplier.get();
                    Optional<ExpressionEditorDefinition<Expression>> expressionEditorDefinition = this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(expression);
                    expressionEditorDefinition.ifPresent(ed -> {
                        Optional<BaseExpressionGrid<Expression, GridData, BaseUIModelMapper>> editor = ed.getEditor(new GridCellTuple(rowIndex, columnIndex, this.gridWidget), Optional.empty(), hasExpression, Optional.empty(), isOnlyVisualChangeAllowed, this.nesting + 1);
                        ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, () -> new ContextGridCell(new ExpressionCellValue(editor), this.listSelector));
                    });
                }
            }
        });
    }

    @Override
    public void toDMNModel(int rowIndex, int columnIndex, Supplier<Optional<GridCellValue<?>>> cell) {
        ((Optional)this.dmnModel.get()).ifPresent(list -> {
            ListUIModelMapperHelper.ListSection section = ListUIModelMapperHelper.getSection(columnIndex);
            switch (section) {
                case ROW_INDEX: {
                    break;
                }
                case EXPRESSION: {
                    ((Optional)cell.get()).ifPresent(v -> {
                        ExpressionCellValue ecv = (ExpressionCellValue)((Object)((Object)v));
                        ((Optional)ecv.getValue()).ifPresent(beg -> ((HasExpression)list.getExpression().get(rowIndex)).setExpression((Expression)beg.getExpression().get().orElse(null)));
                    });
                }
            }
        });
    }
}

