/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGridCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapperHelper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

public class RelationUIModelMapper
extends BaseUIModelMapper<Relation> {
    private final ListSelectorView.Presenter listSelector;
    private final double lineHeight;

    public RelationUIModelMapper(Supplier<GridData> uiModel, Supplier<Optional<Relation>> dmnModel, ListSelectorView.Presenter listSelector, double lineHeight) {
        super(uiModel, dmnModel);
        this.listSelector = listSelector;
        this.lineHeight = lineHeight;
    }

    @Override
    public void fromDMNModel(int rowIndex, int columnIndex) {
        ((Optional)this.dmnModel.get()).ifPresent(relation -> {
            RelationUIModelMapperHelper.RelationSection section = RelationUIModelMapperHelper.getSection(relation, columnIndex);
            switch (section) {
                case ROW_INDEX: {
                    ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, () -> new RelationGridCell(new BaseGridCellValue((Object)(rowIndex + 1)), this.listSelector, this.lineHeight));
                    ((GridData)this.uiModel.get()).getCell(rowIndex, columnIndex).setSelectionStrategy(RowSelectionStrategy.INSTANCE);
                    break;
                }
                case INFORMATION_ITEM: {
                    List row = (List)relation.getRow().get(rowIndex);
                    int iiIndex = RelationUIModelMapperHelper.getInformationItemIndex(relation, columnIndex);
                    HasExpression hasExpression = (HasExpression)row.getExpression().get(iiIndex);
                    Expression e = hasExpression.getExpression();
                    Optional<Expression> expression = Optional.ofNullable(e);
                    expression.ifPresent(ex -> {
                        LiteralExpression le = (LiteralExpression)ex;
                        ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, () -> new RelationGridCell(new BaseGridCellValue((Object)le.getText().getValue()), this.listSelector, this.lineHeight));
                    });
                }
            }
        });
    }

    @Override
    public void toDMNModel(int rowIndex, int columnIndex, Supplier<Optional<GridCellValue<?>>> cell) {
        ((Optional)this.dmnModel.get()).ifPresent(relation -> {
            RelationUIModelMapperHelper.RelationSection section = RelationUIModelMapperHelper.getSection(relation, columnIndex);
            switch (section) {
                case ROW_INDEX: {
                    break;
                }
                case INFORMATION_ITEM: {
                    List row = (List)relation.getRow().get(rowIndex);
                    int iiIndex = RelationUIModelMapperHelper.getInformationItemIndex(relation, columnIndex);
                    HasExpression hasExpression = (HasExpression)row.getExpression().get(iiIndex);
                    Expression e = hasExpression.getExpression();
                    Optional<Expression> expression = Optional.ofNullable(e);
                    expression.ifPresent(arg_0 -> RelationUIModelMapper.lambda$toDMNModel$4((Supplier)cell, arg_0));
                }
            }
        });
    }

    private static /* synthetic */ void lambda$toDMNModel$4(Supplier cell, Expression ex) {
        LiteralExpression le = (LiteralExpression)ex;
        le.getText().setValue((String)((GridCellValue)((Optional)cell.get()).orElse(new BaseGridCellValue((Object)""))).getValue());
    }
}

