/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.common;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;

@ApplicationScoped
public class DataTypeStackHash {
    private final DataTypeStore dataTypeStore;

    @Inject
    public DataTypeStackHash(DataTypeStore dataTypeStore) {
        this.dataTypeStore = dataTypeStore;
    }

    public String calculateHash(DataType dataType) {
        return this.calculateHash(dataType, dataType.getName());
    }

    public String calculateParentHash(DataType reference) {
        return this.getParent(reference).map(dataType -> this.calculateHash((DataType)dataType, dataType.getName())).orElse("");
    }

    private String calculateHash(DataType dataType, String hash) {
        Optional<DataType> parent = this.getParent(dataType);
        if (!parent.isPresent()) {
            return hash;
        }
        return this.calculateHash(parent.get(), parent.get().getName() + "." + hash);
    }

    private Optional<DataType> getParent(DataType dataType) {
        return Optional.ofNullable(this.dataTypeStore.get(dataType.getParentUUID()));
    }
}

