/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months;

import com.google.gwt.event.dom.client.BlurEvent;
import elemental2.dom.Event;
import elemental2.dom.HTMLInputElement;
import java.util.Objects;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsValue;

@Templated
@Dependent
public class YearsMonthsSelectorView
implements YearsMonthsSelector.View {
    private YearsMonthsSelectorView presenter;
    @DataField(value="years-input")
    private final HTMLInputElement yearInput;
    @DataField(value="months-input")
    private final HTMLInputElement monthInput;
    private Consumer<BlurEvent> onValueInputBlur;

    @Inject
    public YearsMonthsSelectorView(HTMLInputElement yearInput, HTMLInputElement monthInput) {
        this.yearInput = yearInput;
        this.monthInput = monthInput;
    }

    public void init(YearsMonthsSelectorView presenter) {
        this.presenter = presenter;
    }

    @Override
    public YearsMonthsValue getValue() {
        YearsMonthsValue value = new YearsMonthsValue();
        value.setMonths(this.monthInput.value);
        value.setYears(this.yearInput.value);
        return value;
    }

    @Override
    public void setValue(YearsMonthsValue value) {
        this.yearInput.value = value.getYears();
        this.monthInput.value = value.getMonths();
    }

    @Override
    public void setPlaceHolder(String placeholder) {
        String attribute = "placeholder";
        this.yearInput.setAttribute("placeholder", placeholder);
        this.monthInput.setAttribute("placeholder", placeholder);
    }

    @EventHandler(value={"years-input"})
    public void onYearsInputBlur(BlurEvent blurEvent) {
        this.handle(blurEvent);
    }

    @EventHandler(value={"months-input"})
    public void onMonthsInputBlur(BlurEvent blurEvent) {
        this.handle(blurEvent);
    }

    void handle(BlurEvent blurEvent) {
        Object target = this.getEventTarget(blurEvent);
        if (!Objects.isNull(this.onValueInputBlur) && !this.isYearsOrMonthsInput(target)) {
            this.onValueInputBlur.accept(blurEvent);
        }
    }

    boolean isYearsOrMonthsInput(Object object) {
        return this.yearInput == object || this.monthInput == object;
    }

    @Override
    public void onValueChanged(Consumer<Event> onValueChanged) {
        this.yearInput.onchange = event -> {
            onValueChanged.accept(event);
            return this;
        };
        this.monthInput.onchange = event -> {
            onValueChanged.accept(event);
            return this;
        };
    }

    @Override
    public void onValueInputBlur(Consumer<BlurEvent> blurEvent) {
        this.onValueInputBlur = blurEvent;
    }

    @Override
    public void select() {
        this.yearInput.select();
    }

    Object getEventTarget(BlurEvent blurEvent) {
        return blurEvent.getNativeEvent().getRelatedEventTarget();
    }
}

