/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months;

import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.DurationHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsValue;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class YearsMonthsValueConverter {
    private static final String YEARS = "Y";
    private static final String MONTHS = "M";
    static final String YEARS_TRANSLATION_KEY = "YearsMonthsSelectorView.Years";
    static final String MONTHS_TRANSLATION_KEY = "YearsMonthsSelectorView.Months";
    static final String YEARS_ABBREVIATED_TRANSLATION_KEY = "YearsMonthsSelectorView.YearsAbbreviated";
    static final String MONTHS_ABBREVIATED_TRANSLATION_KEY = "YearsMonthsSelectorView.MonthsAbbreviated";
    private final ClientTranslationService translationService;

    @Inject
    public YearsMonthsValueConverter(ClientTranslationService translationService) {
        this.translationService = translationService;
    }

    public YearsMonthsValue fromDMNString(String dmnString) {
        YearsMonthsValue yearsMonthsValue = new YearsMonthsValue();
        String value = this.removePrefixAndSuffix(dmnString);
        String[] yearsSplit = value.split(YEARS);
        String months = "";
        if (yearsSplit.length > 0 && !yearsSplit[0].equals(value)) {
            yearsMonthsValue.setYears(yearsSplit[0]);
            if (yearsSplit.length == 2) {
                months = this.getMonths(yearsSplit[1]);
            }
        } else {
            months = this.getMonths(value);
        }
        yearsMonthsValue.setMonths(months);
        return yearsMonthsValue;
    }

    private String getMonths(String monthString) {
        String[] months = monthString.split(MONTHS);
        if (months.length > 0) {
            return months[0];
        }
        return "";
    }

    public String toDMNString(String years, String months) {
        YearsMonthsValue value = new YearsMonthsValue();
        value.setYears(years);
        value.setMonths(months);
        return this.toDMNString(value);
    }

    private String toDMNString(YearsMonthsValue yearsMonthsValue) {
        this.matchSigns(yearsMonthsValue);
        String dmnString = "";
        if (!StringUtils.isEmpty((String)yearsMonthsValue.getYears())) {
            dmnString = dmnString + yearsMonthsValue.getYears() + YEARS;
        }
        if (!StringUtils.isEmpty((String)yearsMonthsValue.getMonths())) {
            dmnString = dmnString + yearsMonthsValue.getMonths() + MONTHS;
        }
        if (StringUtils.isEmpty((String)dmnString)) {
            return dmnString;
        }
        return YearsMonthsValueConverter.addPrefixAndSuffix(dmnString);
    }

    public String toDisplayValue(String dmnValue) {
        YearsMonthsValue yearsMonthsValue = this.fromDMNString(dmnValue);
        return this.toDisplayValue(yearsMonthsValue);
    }

    void matchSigns(YearsMonthsValue value) {
        int yearsValue = 0;
        int monthsValue = 0;
        if (!StringUtils.isEmpty((String)value.getYears())) {
            yearsValue = Integer.parseInt(value.getYears());
        }
        if (!StringUtils.isEmpty((String)value.getMonths())) {
            monthsValue = Integer.parseInt(value.getMonths());
        }
        if (yearsValue < 0 && monthsValue > 0) {
            value.setMonths("-" + value.getMonths());
        } else if (monthsValue < 0 && yearsValue > 0) {
            value.setYears("-" + value.getYears());
        }
    }

    String toDisplayValue(YearsMonthsValue yearsMonthsValue) {
        String displayValue;
        boolean hasMonths;
        String years = yearsMonthsValue.getYears();
        String months = yearsMonthsValue.getMonths();
        boolean hasYears = !StringUtils.isEmpty((String)years);
        boolean bl = hasMonths = !StringUtils.isEmpty((String)months);
        if (hasYears && hasMonths) {
            String yearsString = this.translationService.getValue(YEARS_TRANSLATION_KEY);
            String monthsString = this.translationService.getValue(MONTHS_TRANSLATION_KEY);
            displayValue = years + " " + yearsString + ", " + months + " " + monthsString;
        } else {
            displayValue = hasYears ? years + " " + this.translationService.getValue(YEARS_ABBREVIATED_TRANSLATION_KEY) : (hasMonths ? months + " " + this.translationService.getValue(MONTHS_ABBREVIATED_TRANSLATION_KEY) : "");
        }
        return displayValue;
    }

    static String addPrefixAndSuffix(String value) {
        return DurationHelper.addFunctionCall("P" + value);
    }

    String removePrefixAndSuffix(String dmnString) {
        return DurationHelper.getFunctionParameter(dmnString).substring(1);
    }
}

