/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.tooltip;

import elemental2.dom.HTMLElement;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeKind;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.uberfire.client.mvp.UberElemental;

@ApplicationScoped
public class StructureTypesTooltip {
    private final View view;
    private final DataTypeUtils dataTypeUtils;
    private final DataTypeList dataTypeList;
    private final DataTypeManager dataTypeManager;
    private String typeName;

    @Inject
    public StructureTypesTooltip(View view, DataTypeUtils dataTypeUtils, DataTypeList dataTypeList, DataTypeManager dataTypeManager) {
        this.view = view;
        this.dataTypeUtils = dataTypeUtils;
        this.dataTypeList = dataTypeList;
        this.dataTypeManager = dataTypeManager;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public void show(HTMLElement refElement, String typeName) {
        this.typeName = typeName;
        this.view.show(refElement);
    }

    HTMLElement getListItems() {
        return this.dataTypeList.getListItems();
    }

    List<DataType> getTypeFields() {
        return this.dataTypeManager.getTopLevelDataTypeWithName(this.getTypeName()).map(DataType::getSubDataTypes).orElse(Collections.emptyList());
    }

    DataTypeKind getDataTypeKind() {
        return this.dataTypeUtils.getDataTypeKind(this.typeName);
    }

    void goToDataType() {
        this.dataTypeManager.getTopLevelDataTypeWithName(this.getTypeName()).flatMap(this.dataTypeList::findItem).ifPresent(DataTypeListItem::enableShortcutsHighlight);
    }

    String getTypeName() {
        return this.typeName;
    }

    public static interface View
    extends UberElemental<StructureTypesTooltip>,
    IsElement {
        public void show(HTMLElement var1);
    }
}

