/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.tooltip;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.DOMRect;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.EventListener;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLBodyElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.HTMLParagraphElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeKind;
import org.kie.workbench.common.dmn.client.editors.types.listview.tooltip.StructureTypesTooltip;

@ApplicationScoped
@Templated
public class StructureTypesTooltipView
implements StructureTypesTooltip.View {
    static final String DISPLAY_BLOCK = "block";
    static final String DISPLAY_NONE = "none";
    final EventListener SCROLL_LISTENER = event -> this.hide();
    final EventListener CLICK_LISTENER = event -> {
        if (this.isOutside(event)) {
            this.hide();
        }
    };
    @DataField(value="data-type-details-tooltip")
    private final HTMLDivElement tooltip;
    @DataField(value="close")
    private final HTMLButtonElement close;
    @DataField(value="data-type-name")
    private final HTMLHeadingElement dataTypeName;
    @DataField(value="description")
    private final HTMLParagraphElement description;
    @DataField(value="data-type-fields")
    private final HTMLUListElement dataTypeFields;
    @DataField(value="data-type-field")
    private final HTMLLIElement htmlLiElement;
    @DataField(value="data-type-field-type")
    private final HTMLElement htmlSpanElement;
    @DataField(value="view-data-type-link")
    private final HTMLAnchorElement viewDataTypeLink;
    private final TranslationService translationService;
    private StructureTypesTooltip presenter;

    @Inject
    public StructureTypesTooltipView(HTMLDivElement tooltip, HTMLButtonElement close, @Named(value="h3") HTMLHeadingElement dataTypeName, HTMLParagraphElement description, HTMLUListElement dataTypeFields, HTMLLIElement htmlLiElement, @Named(value="span") HTMLElement htmlSpanElement, HTMLAnchorElement viewDataTypeLink, TranslationService translationService) {
        this.tooltip = tooltip;
        this.close = close;
        this.dataTypeName = dataTypeName;
        this.description = description;
        this.dataTypeFields = dataTypeFields;
        this.htmlLiElement = htmlLiElement;
        this.htmlSpanElement = htmlSpanElement;
        this.viewDataTypeLink = viewDataTypeLink;
        this.translationService = translationService;
    }

    @PostConstruct
    void setup() {
        this.getBody().appendChild((Node)this.getElement());
        this.tooltip.style.display = DISPLAY_NONE;
    }

    public void init(StructureTypesTooltip presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"close"})
    public void onClose(ClickEvent e) {
        this.hide();
    }

    @EventHandler(value={"view-data-type-link"})
    public void onViewDataTypeLink(ClickEvent event) {
        this.presenter.goToDataType();
        this.hide();
        event.stopPropagation();
        event.preventDefault();
    }

    @Override
    public void show(HTMLElement refElement) {
        this.updateTooltipPosition(refElement);
        this.updateTooltipAsVisible();
        this.updateContent();
        this.updateTooltipClass();
        this.setupListeners();
    }

    public void hide() {
        this.updateTooltipAsHidden();
        this.teardownListeners();
    }

    void updateContent() {
        List<DataType> typeFields = this.presenter.getTypeFields();
        this.dataTypeName.textContent = this.presenter.getTypeName();
        this.getDescriptionText().ifPresent(text -> {
            this.description.textContent = text;
        });
        RemoveHelper.removeChildren((Element)this.dataTypeFields);
        typeFields.forEach(field -> this.dataTypeFields.appendChild((Node)this.makeFieldElement((DataType)field)));
    }

    Optional<String> getDescriptionText() {
        String typeName = this.presenter.getTypeName();
        DataTypeKind dataTypeKind = this.presenter.getDataTypeKind();
        switch (dataTypeKind) {
            case CUSTOM: {
                return Optional.ofNullable(this.translationService.format("StructureTypesTooltipView.DescriptionCustom", new Object[]{typeName}));
            }
            case STRUCTURE: {
                int numberOfFields = this.presenter.getTypeFields().size();
                return Optional.ofNullable(this.translationService.format("StructureTypesTooltipView.DescriptionStructured", new Object[]{typeName, numberOfFields}));
            }
            case INCLUDED: {
                return Optional.ofNullable(this.translationService.format("StructureTypesTooltipView.DescriptionIncluded", new Object[]{typeName}));
            }
        }
        return Optional.empty();
    }

    void setupListeners() {
        this.getListItems().addEventListener("scroll", this.SCROLL_LISTENER);
        this.getBody().addEventListener("click", this.CLICK_LISTENER);
    }

    void teardownListeners() {
        this.getListItems().removeEventListener("scroll", this.SCROLL_LISTENER);
        this.getBody().removeEventListener("click", this.CLICK_LISTENER);
    }

    boolean isOutside(Event event) {
        HTMLElement target;
        HTMLElement element = this.getElement();
        return !element.contains((Node)(target = (HTMLElement)event.target)) && this.isTooltipVisible();
    }

    boolean isTooltipVisible() {
        return this.tooltip.style.display.equals(DISPLAY_BLOCK);
    }

    void updateTooltipAsVisible() {
        this.tooltip.style.display = DISPLAY_BLOCK;
    }

    void updateTooltipAsHidden() {
        this.tooltip.style.display = DISPLAY_NONE;
    }

    void updateTooltipPosition(HTMLElement refElement) {
        DOMRect refRect = refElement.getBoundingClientRect();
        int PADDING = 20;
        double x = 20.0 + refRect.x + refRect.width;
        double y = refRect.y;
        this.tooltip.style.top = y + "px";
        this.tooltip.style.left = x + "px";
    }

    void updateTooltipClass() {
        this.tooltip.classList.toggle("overflow", this.isTooltipOverflowing());
    }

    private boolean isTooltipOverflowing() {
        DOMRect dataTypesListRect = this.getListItems().getBoundingClientRect();
        DOMRect tooltipRect = this.tooltip.getBoundingClientRect();
        return tooltipRect.y + tooltipRect.height > dataTypesListRect.y + dataTypesListRect.height;
    }

    HTMLLIElement makeFieldElement(DataType field) {
        HTMLLIElement htmlLiElement = this.makeHTMLLIElement();
        String name = field.getName();
        HTMLElement type = this.makeTypeElement(field);
        htmlLiElement.textContent = name;
        htmlLiElement.appendChild((Node)type);
        return htmlLiElement;
    }

    HTMLBodyElement getBody() {
        return DomGlobal.document.body;
    }

    private HTMLElement getListItems() {
        return this.presenter.getListItems();
    }

    HTMLElement makeTypeElement(DataType field) {
        HTMLElement htmlSpanElement = this.makeHTMLElement();
        htmlSpanElement.textContent = field.getType();
        return htmlSpanElement;
    }

    HTMLLIElement makeHTMLLIElement() {
        return (HTMLLIElement)this.htmlLiElement.cloneNode(false);
    }

    HTMLElement makeHTMLElement() {
        return (HTMLElement)this.htmlSpanElement.cloneNode(false);
    }
}

