/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.graph;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.NodeTextSetter;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.forms.client.event.FormFieldChanged;

@ApplicationScoped
public class DMNElementsSynchronizer {
    private final DMNDiagramsSession dmnDiagramsSession;
    private final Event<RefreshDecisionComponents> refreshDecisionComponentsEvent;
    private final DMNGraphUtils graphUtils;
    private final NodeTextSetter nodeTextSetter;

    @Inject
    public DMNElementsSynchronizer(DMNDiagramsSession dmnDiagramsSession, Event<RefreshDecisionComponents> refreshDecisionComponentsEvent, DMNGraphUtils graphUtils, NodeTextSetter nodeTextSetter) {
        this.dmnDiagramsSession = dmnDiagramsSession;
        this.refreshDecisionComponentsEvent = refreshDecisionComponentsEvent;
        this.graphUtils = graphUtils;
        this.nodeTextSetter = nodeTextSetter;
    }

    public void onExpressionEditorChanged(@Observes ExpressionEditorChanged event) {
        Optional<Node> node = this.getNode(event.getNodeUUID());
        this.synchronizeFromNode(node);
    }

    public void onPropertyChanged(@Observes FormFieldChanged event) {
        Optional<Node> node = this.getNode(event.getUuid());
        this.synchronizeFromNode(node);
    }

    public void synchronizeElementsFrom(DRGElement drgElement) {
        String contentDefinitionId = drgElement.getContentDefinitionId();
        List<Node> nodes = this.getElementsWithContentId(contentDefinitionId);
        for (Node node : nodes) {
            this.updateText(drgElement, node);
            DRGElement element = this.getDRGElementFromContentDefinition(node);
            this.synchronizeBaseDRGProperties(drgElement, element);
            this.synchronizeSpecializedProperties(drgElement, element);
        }
        this.refreshDecisionComponentsEvent.fire((Object)new RefreshDecisionComponents());
    }

    void synchronizeSpecializedProperties(DRGElement drgElement, DRGElement element) {
        if (element instanceof Decision) {
            this.synchronizeDecisionNode((Decision)drgElement, (Decision)element);
        } else if (element instanceof BusinessKnowledgeModel) {
            this.synchronizeBusinessKnowledgeModelNode((BusinessKnowledgeModel)drgElement, (BusinessKnowledgeModel)element);
        } else if (element instanceof DecisionService) {
            this.synchronizeDecisionServiceNode((DecisionService)drgElement, (DecisionService)element);
        } else if (element instanceof InputData) {
            this.synchronizeInputDataNode((InputData)drgElement, (InputData)element);
        } else if (element instanceof KnowledgeSource) {
            this.synchronizeKnowledgeSourceNode((KnowledgeSource)drgElement, (KnowledgeSource)element);
        }
    }

    void synchronizeBaseDRGProperties(DRGElement from, DRGElement to) {
        to.setDescription(from.getDescription());
        to.setLinksHolder(from.getLinksHolder());
        to.setName(from.getName());
    }

    void synchronizeKnowledgeSourceNode(KnowledgeSource from, KnowledgeSource to) {
        to.setType(from.getType());
        to.setLocationURI(from.getLocationURI());
    }

    void synchronizeInputDataNode(InputData from, InputData to) {
        to.setVariable(from.getVariable());
    }

    void synchronizeDecisionServiceNode(DecisionService from, DecisionService to) {
        to.setVariable(from.getVariable());
    }

    void synchronizeBusinessKnowledgeModelNode(BusinessKnowledgeModel from, BusinessKnowledgeModel to) {
        to.setVariable(from.getVariable());
    }

    void synchronizeDecisionNode(Decision from, Decision to) {
        to.setQuestion(from.getQuestion());
        to.setAllowedAnswers(from.getAllowedAnswers());
        to.setExpression(from.getExpression());
        to.setVariable(from.getVariable());
    }

    void updateText(DRGElement from, Node to) {
        String name = from.getName().getValue();
        this.nodeTextSetter.setText(name, to);
    }

    List<Node> getElementsWithContentId(String contentDefinitionId) {
        List<Node> allNodes = this.dmnDiagramsSession.getAllNodes();
        return allNodes.stream().filter(node -> this.definitionContainsDRGElement((Node)node) && Objects.equals(this.getDRGElementFromContentDefinition((Node)node).getContentDefinitionId(), contentDefinitionId)).collect(Collectors.toList());
    }

    boolean definitionContainsDRGElement(Node node) {
        return node.getContent() instanceof Definition && ((Definition)node.getContent()).getDefinition() instanceof DRGElement;
    }

    DRGElement getDRGElementFromContentDefinition(Node node) {
        return (DRGElement)((Definition)node.getContent()).getDefinition();
    }

    Optional<Node> getNode(String nodeUUID) {
        return this.graphUtils.getNodeStream().filter(node -> Objects.equals(node.getUUID(), nodeUUID)).findFirst();
    }

    public void synchronizeFromNode(Optional<Node> node) {
        node.ifPresent(n -> {
            Definition definition;
            if (n.getContent() instanceof Definition && (definition = (Definition)n.getContent()).getDefinition() instanceof DRGElement) {
                DRGElement drgElement = (DRGElement)definition.getDefinition();
                this.synchronizeElementsFrom(drgElement);
            }
        });
    }
}

