/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Binding;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.client.marshaller.converters.ExpressionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.InformationItemPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBinding;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITExpression;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;

public class BindingPropertyConverter {
    public static Binding wbFromDMN(JSITBinding dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        if (Objects.isNull(dmn)) {
            return null;
        }
        InformationItem parameter = InformationItemPropertyConverter.wbFromDMN(dmn.getParameter());
        Expression expression = null;
        JSITExpression jsiWrapped = dmn.getExpression();
        if (Objects.nonNull(jsiWrapped)) {
            JSITExpression jsiExpression = (JSITExpression)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)jsiWrapped));
            expression = ExpressionPropertyConverter.wbFromDMN(jsiExpression, (JSITExpression)Js.uncheckedCast((Object)dmn), hasComponentWidthsConsumer);
        }
        Binding result = new Binding();
        if (Objects.nonNull(parameter)) {
            parameter.setParent((DMNModelInstrumentedBase)result);
        }
        result.setParameter(parameter);
        if (Objects.nonNull(expression)) {
            expression.setParent((DMNModelInstrumentedBase)result);
        }
        result.setExpression(expression);
        return result;
    }

    public static JSITBinding dmnFromWB(Binding wb, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        if (Objects.isNull(wb)) {
            return null;
        }
        JSITBinding result = new JSITBinding();
        JSITInformationItem convertedParameter = InformationItemPropertyConverter.dmnFromWB(wb.getParameter());
        JSITExpression convertedExpression = ExpressionPropertyConverter.dmnFromWB(wb.getExpression(), componentWidthsConsumer);
        result.setParameter(convertedParameter);
        result.setExpression(convertedExpression);
        return result;
    }
}

