/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.included;

import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.api.marshalling.DMNMarshallerImportsHelper;
import org.kie.workbench.common.dmn.client.marshaller.converters.ImportedItemDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNIncludedNodeFactory;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsContentService;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInvocable;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.util.FileUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.promise.Promises;

public class DMNMarshallerImportsClientHelper
implements DMNMarshallerImportsHelper<JSITImport, JSITDefinitions, JSITDRGElement, JSITItemDefinition> {
    private final DMNMarshallerImportsService dmnImportsService;
    private final DMNMarshallerImportsContentService dmnImportsContentService;
    private final Promises promises;
    private final DMNIncludedNodeFactory includedModelFactory;
    private static final Logger LOGGER = Logger.getLogger(DMNMarshallerImportsClientHelper.class.getName());

    @Inject
    public DMNMarshallerImportsClientHelper(DMNMarshallerImportsService dmnImportsService, DMNMarshallerImportsContentService dmnImportsContentService, Promises promises, DMNIncludedNodeFactory includedModelFactory) {
        this.dmnImportsService = dmnImportsService;
        this.dmnImportsContentService = dmnImportsContentService;
        this.promises = promises;
        this.includedModelFactory = includedModelFactory;
    }

    public Promise<Map<JSITImport, JSITDefinitions>> getImportDefinitionsAsync(Metadata metadata, List<JSITImport> imports) {
        if (!imports.isEmpty()) {
            return this.loadDMNDefinitions().then(otherDefinitions -> {
                HashMap importDefinitions = new HashMap();
                for (Map.Entry entry : otherDefinitions.entrySet()) {
                    JSITDefinitions def = (JSITDefinitions)Js.uncheckedCast(entry.getValue());
                    this.findImportByDefinitions(def, imports).ifPresent(anImport -> {
                        JSITImport foundImported = (JSITImport)Js.uncheckedCast((Object)anImport);
                        importDefinitions.put(foundImported, def);
                    });
                }
                return this.promises.resolve(importDefinitions);
            });
        }
        return this.promises.resolve(Collections.emptyMap());
    }

    private Promise<Map<String, JSITDefinitions>> loadDMNDefinitions() {
        return this.dmnImportsContentService.getModelsDMNFilesURIs().then(list -> {
            if (((String[])list).length == 0) {
                return this.promises.resolve(Collections.emptyMap());
            }
            ConcurrentHashMap otherDefinitions = new ConcurrentHashMap();
            return this.promises.all(Arrays.asList(list), file -> this.loadDefinitionFromFile((String)file, otherDefinitions)).then(v -> this.promises.resolve((Object)otherDefinitions));
        });
    }

    public void loadNodesFromModels(List<DMNIncludedModel> includedModels, ServiceCallback<List<DMNIncludedNode>> callback) {
        ArrayList result = new ArrayList();
        if (includedModels.isEmpty()) {
            callback.onSuccess(result);
        } else {
            this.loadDMNDefinitions().then(existingDefinitions -> this.promises.all(includedModels, model -> this.loadNodes((Map<String, JSITDefinitions>)existingDefinitions, (DMNIncludedModel)model, result)).then(p -> {
                callback.onSuccess((Object)result);
                return this.promises.resolve();
            }));
        }
    }

    private Promise<List<DMNIncludedNode>> loadNodes(Map<String, JSITDefinitions> existingDefinitions, final DMNIncludedModel model, final List<DMNIncludedNode> result) {
        String filePath = "";
        for (Map.Entry<String, JSITDefinitions> entry : existingDefinitions.entrySet()) {
            filePath = entry.getKey();
            JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)entry.getValue());
            if (!Objects.equals(model.getNamespace(), definitions.getNamespace())) continue;
            break;
        }
        if (StringUtils.isEmpty((String)filePath)) {
            return this.promises.resolve();
        }
        final String path = filePath;
        return this.dmnImportsContentService.loadFile(path).then(content -> this.promises.create((success, fail) -> this.dmnImportsService.getDRGElements((String)content, new ServiceCallback<List<DRGElement>>(){

            public void onSuccess(List<DRGElement> drgElements) {
                List nodes = drgElements.stream().map(node -> DMNMarshallerImportsClientHelper.this.includedModelFactory.makeDMNIncludeNode(path, (IncludedModel)model, (DRGElement)node)).collect(Collectors.toList());
                result.addAll(nodes);
                success.onInvoke(nodes);
            }

            public void onError(ClientRuntimeError error) {
                LOGGER.log(Level.SEVERE, error.getMessage());
                fail.onInvoke((Object)error);
            }
        })));
    }

    public void loadModels(ServiceCallback<List<IncludedModel>> callback) {
        final ArrayList models = new ArrayList();
        this.dmnImportsContentService.getModelsURIs().then(items -> this.promises.all(Arrays.asList(items), file -> {
            final String fileName = FileUtils.getFileName((String)file);
            if (fileName.endsWith("." + DMNImportTypes.DMN.getFileExtension())) {
                return this.dmnImportsContentService.loadFile((String)file).then(fileContent -> this.promises.create((success, failed) -> this.dmnImportsService.getWbDefinitions((String)fileContent, new ServiceCallback<Definitions>(){

                    public void onSuccess(Definitions definitions) {
                        String modelPackage = "";
                        String namespace = definitions.getNamespace().getValue();
                        String importType = DMNImportTypes.DMN.getDefaultNamespace();
                        int drgElementCount = definitions.getDrgElement().size();
                        int itemDefinitionCount = definitions.getItemDefinition().size();
                        models.add(new DMNIncludedModel(fileName, "", fileName, namespace, importType, Integer.valueOf(drgElementCount), Integer.valueOf(itemDefinitionCount)));
                        success.onInvoke((IThenable)DMNMarshallerImportsClientHelper.this.promises.resolve());
                    }

                    public void onError(ClientRuntimeError error) {
                        success.onInvoke((IThenable)DMNMarshallerImportsClientHelper.this.promises.resolve());
                    }
                })));
            }
            if (fileName.endsWith("." + DMNImportTypes.PMML.getFileExtension())) {
                return this.dmnImportsContentService.getPMMLDocumentMetadata((String)file).then(pmmlDocumentMetadata -> {
                    int modelCount = pmmlDocumentMetadata.getModels() != null ? pmmlDocumentMetadata.getModels().size() : 0;
                    models.add(new PMMLIncludedModel(fileName, "", fileName, DMNImportTypes.PMML.getDefaultNamespace(), Integer.valueOf(modelCount)));
                    return this.promises.resolve();
                });
            }
            return this.promises.reject((Object)("Error: " + fileName + " is an invalid file. Only *.dmn and *.pmml are supported"));
        }).then(v -> {
            callback.onSuccess((Object)models);
            return this.promises.resolve();
        }));
    }

    private Promise<Void> loadDefinitionFromFile(String file, Map<String, JSITDefinitions> otherDefinitions) {
        return this.dmnImportsContentService.loadFile(file).then(xml -> this.promises.create((success, failure) -> {
            if (!StringUtils.isEmpty((String)xml)) {
                ServiceCallback callback = (ServiceCallback)Js.uncheckedCast(this.getCallback(file, otherDefinitions, (Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Void>)success));
                this.dmnImportsService.getDMNDefinitions((String)xml, (ServiceCallback<JSITDefinitions>)callback);
            } else {
                success.onInvoke((IThenable)this.promises.resolve());
            }
        }));
    }

    private ServiceCallback<Object> getCallback(final String filePath, final Map<String, JSITDefinitions> otherDefinitions, final Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Void> success) {
        return new ServiceCallback<Object>(){

            public void onSuccess(Object item) {
                JSITDefinitions def = (JSITDefinitions)Js.uncheckedCast((Object)item);
                otherDefinitions.put(filePath, def);
                success.onInvoke((IThenable)DMNMarshallerImportsClientHelper.this.promises.resolve());
            }

            public void onError(ClientRuntimeError error) {
                LOGGER.log(Level.SEVERE, error.getMessage());
            }
        };
    }

    private Optional<JSITImport> findImportByDefinitions(JSITDefinitions definitions, List<JSITImport> imports) {
        for (int i = 0; i < imports.size(); ++i) {
            JSITImport anImport = (JSITImport)Js.uncheckedCast((Object)imports.get(i));
            if (!Objects.equals(anImport.getNamespace(), definitions.getNamespace())) continue;
            return Optional.of(anImport);
        }
        return Optional.empty();
    }

    private Optional<JSITImport> findImportByPMMLDocument(String includedPMMLModelFile, List<JSITImport> imports) {
        for (int i = 0; i < imports.size(); ++i) {
            JSITImport anImport = (JSITImport)Js.uncheckedCast((Object)imports.get(i));
            if (!Objects.equals(anImport.getLocationURI(), includedPMMLModelFile)) continue;
            return Optional.of(anImport);
        }
        return Optional.empty();
    }

    public Promise<Map<JSITImport, PMMLDocumentMetadata>> getPMMLDocumentsAsync(Metadata metadata, List<JSITImport> imports) {
        if (!imports.isEmpty()) {
            return this.loadPMMLDefinitions().then(otherDefinitions -> {
                HashMap importDefinitions = new HashMap();
                for (Map.Entry entry : otherDefinitions.entrySet()) {
                    PMMLDocumentMetadata def = (PMMLDocumentMetadata)entry.getValue();
                    this.findImportByPMMLDocument(FileUtils.getFileName((String)def.getPath()), imports).ifPresent(anImport -> {
                        JSITImport foundImported = (JSITImport)Js.uncheckedCast((Object)anImport);
                        importDefinitions.put(foundImported, def);
                    });
                }
                return this.promises.resolve(importDefinitions);
            });
        }
        return this.promises.resolve(Collections.emptyMap());
    }

    private Promise<Map<String, PMMLDocumentMetadata>> loadPMMLDefinitions() {
        return this.dmnImportsContentService.getModelsPMMLFilesURIs().then(files -> {
            if (((String[])files).length == 0) {
                return this.promises.resolve(Collections.emptyMap());
            }
            HashMap definitions = new HashMap();
            return this.promises.all(Arrays.asList(files), file -> this.loadPMMLDefinitionFromFile((String)file, definitions).then(v -> this.promises.resolve((Object)definitions)));
        });
    }

    private Promise<Void> loadPMMLDefinitionFromFile(String file, Map<String, PMMLDocumentMetadata> definitions) {
        return this.dmnImportsContentService.getPMMLDocumentMetadata(file).then(pmmlDocumentMetadata -> {
            definitions.put(file, (PMMLDocumentMetadata)pmmlDocumentMetadata);
            return this.promises.resolve();
        });
    }

    public Map<JSITImport, String> getImportXML(Metadata metadata, List<JSITImport> imports) {
        return Collections.emptyMap();
    }

    public List<JSITDRGElement> getImportedDRGElements(Map<JSITImport, JSITDefinitions> importDefinitions) {
        ArrayList<JSITDRGElement> importedNodes = new ArrayList<JSITDRGElement>();
        for (Map.Entry<JSITImport, JSITDefinitions> entry : importDefinitions.entrySet()) {
            JSITImport anImport = (JSITImport)Js.uncheckedCast((Object)entry.getKey());
            JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)entry.getValue());
            importedNodes.addAll(this.getDrgElementsWithNamespace(definitions, anImport));
        }
        return importedNodes;
    }

    private List<JSITDRGElement> getDrgElementsWithNamespace(JSITDefinitions definitions, JSITImport anImport) {
        ArrayList<JSITDRGElement> result = new ArrayList<JSITDRGElement>();
        List drgElements = definitions.getDrgElement();
        for (int i = 0; i < drgElements.size(); ++i) {
            JSITDRGElement drgElement = (JSITDRGElement)Js.uncheckedCast(drgElements.get(i));
            JSITDRGElement element = (JSITDRGElement)Js.uncheckedCast((Object)this.drgElementWithNamespace(drgElement, anImport));
            result.add(element);
        }
        return result;
    }

    private JSITDRGElement drgElementWithNamespace(JSITDRGElement drgElement, JSITImport anImport) {
        String namespace = anImport.getName();
        QName qname = QName.valueOf("Namespace");
        Map map = JSITDMNElement.getOtherAttributesMap((JSITDMNElement)drgElement);
        map.put(qname, anImport.getNamespace());
        drgElement.setOtherAttributes(map);
        drgElement.setName(namespace + "." + drgElement.getName());
        this.updateInformationItem(namespace, drgElement);
        return drgElement;
    }

    private void updateInformationItem(String namespace, JSITDRGElement drgElement) {
        this.getInformationItem(drgElement).ifPresent(informationItem -> {
            JSITInformationItem tInformationItem = new JSITInformationItem();
            String typeRef = informationItem.getTypeRef();
            if (!StringUtils.isEmpty((String)typeRef) && !BuiltInTypeUtils.isBuiltInType((String)typeRef)) {
                tInformationItem.setTypeRef(namespace + "." + typeRef);
                this.setInformationItem(drgElement, tInformationItem);
            }
        });
    }

    private void setInformationItem(JSITDRGElement drgElement, JSITInformationItem informationItem) {
        if (JSITDecision.instanceOf((Object)drgElement)) {
            JSITDecision decision = (JSITDecision)Js.uncheckedCast((Object)drgElement);
            decision.setVariable(informationItem);
        } else if (JSITInputData.instanceOf((Object)drgElement)) {
            JSITInputData inputData = (JSITInputData)Js.uncheckedCast((Object)drgElement);
            inputData.setVariable(informationItem);
        } else if (JSITInvocable.instanceOf((Object)drgElement)) {
            JSITInvocable invocable = (JSITInvocable)Js.uncheckedCast((Object)drgElement);
            invocable.setVariable(informationItem);
        }
    }

    private Optional<JSITInformationItem> getInformationItem(JSITDRGElement drgElement) {
        JSITInformationItem variable;
        if (JSITDecision.instanceOf((Object)drgElement)) {
            JSITDecision decision = (JSITDecision)Js.uncheckedCast((Object)drgElement);
            variable = (JSITInformationItem)Js.uncheckedCast((Object)decision.getVariable());
        } else if (JSITInputData.instanceOf((Object)drgElement)) {
            JSITInputData inputData = (JSITInputData)Js.uncheckedCast((Object)drgElement);
            variable = (JSITInformationItem)Js.uncheckedCast((Object)inputData.getVariable());
        } else if (JSITInvocable.instanceOf((Object)drgElement)) {
            JSITInvocable invocable = (JSITInvocable)Js.uncheckedCast((Object)drgElement);
            variable = (JSITInformationItem)Js.uncheckedCast((Object)invocable.getVariable());
        } else {
            return Optional.empty();
        }
        return Optional.of(variable);
    }

    public List<JSITItemDefinition> getImportedItemDefinitions(Map<JSITImport, JSITDefinitions> importDefinitions) {
        ArrayList<JSITItemDefinition> itemDefinitions = new ArrayList<JSITItemDefinition>();
        for (Map.Entry<JSITImport, JSITDefinitions> entry : importDefinitions.entrySet()) {
            JSITImport anImport = (JSITImport)Js.uncheckedCast((Object)entry.getKey());
            JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)entry.getValue());
            List<JSITItemDefinition> items = this.getItemDefinitionsWithNamespace(definitions, anImport);
            itemDefinitions.addAll(items);
        }
        return itemDefinitions;
    }

    private List<JSITItemDefinition> getItemDefinitionsWithNamespace(JSITDefinitions definitions, JSITImport anImport) {
        List itemDefinitions = definitions.getItemDefinition();
        String prefix = anImport.getName();
        ArrayList<JSITItemDefinition> result = new ArrayList<JSITItemDefinition>();
        for (int i = 0; i < itemDefinitions.size(); ++i) {
            JSITItemDefinition itemDefinition = (JSITItemDefinition)Js.uncheckedCast(itemDefinitions.get(i));
            JSITItemDefinition item = (JSITItemDefinition)Js.uncheckedCast((Object)ImportedItemDefinitionPropertyConverter.withNamespace(itemDefinition, prefix));
            result.add(item);
        }
        return result;
    }

    public void getPMMLDocumentsMetadataFromFiles(List<PMMLIncludedModel> includedModels, ServiceCallback<List<PMMLDocumentMetadata>> callback) {
        if (includedModels == null || includedModels.isEmpty()) {
            callback.onSuccess(Collections.emptyList());
            return;
        }
        this.loadPMMLDefinitions().then(allDefinitions -> {
            Map<String, String> filesToNameMap = includedModels.stream().collect(Collectors.toMap(BaseIncludedModel::getPath, BaseIncludedModel::getModelName));
            List pmmlDocumentMetadata = allDefinitions.entrySet().stream().filter(entry -> filesToNameMap.keySet().contains(FileUtils.getFileName((String)((String)entry.getKey())))).map(entry -> new PMMLDocumentMetadata(((PMMLDocumentMetadata)entry.getValue()).getPath(), (String)filesToNameMap.get(FileUtils.getFileName((String)((String)entry.getKey()))), ((PMMLDocumentMetadata)entry.getValue()).getImportType(), ((PMMLDocumentMetadata)entry.getValue()).getModels())).collect(Collectors.toList());
            pmmlDocumentMetadata.sort(Comparator.comparing(PMMLDocumentMetadata::getName));
            callback.onSuccess(pmmlDocumentMetadata);
            return this.promises.resolve();
        });
    }

    public void getImportedItemDefinitionsByNamespaceAsync(String modelName, String namespace, ServiceCallback<List<ItemDefinition>> callback) {
        this.loadDMNDefinitions().then(definitions -> {
            ArrayList<ItemDefinition> result = new ArrayList<ItemDefinition>();
            for (Map.Entry entry : definitions.entrySet()) {
                JSITDefinitions definition = (JSITDefinitions)Js.uncheckedCast(entry.getValue());
                if (!Objects.equals(definition.getNamespace(), namespace)) continue;
                List items = definition.getItemDefinition();
                for (int j = 0; j < items.size(); ++j) {
                    JSITItemDefinition jsitItemDefinition = (JSITItemDefinition)Js.uncheckedCast(items.get(j));
                    ItemDefinition converted = ImportedItemDefinitionPropertyConverter.wbFromDMN(jsitItemDefinition, modelName);
                    result.add(converted);
                }
            }
            result.sort(Comparator.comparing(o -> o.getName().getValue()));
            callback.onSuccess(result);
            return this.promises.resolve(result);
        });
    }
}

