/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.included;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.client.marshaller.converters.DefinitionsConverter;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntriesFactory;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.callbacks.DMN12UnmarshallCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
public class DMNMarshallerImportsService {
    private final NodeEntriesFactory modelToStunnerConverter;

    @Inject
    public DMNMarshallerImportsService(NodeEntriesFactory modelToStunnerConverter) {
        this.modelToStunnerConverter = modelToStunnerConverter;
    }

    public void getDRGElements(String dmnXml, ServiceCallback<List<DRGElement>> callback) {
        DMN12UnmarshallCallback jsCallback = dmn12 -> {
            JSITDefinitions dmnDefinitions = (JSITDefinitions)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)dmn12));
            callback.onSuccess(this.modelToStunnerConverter.makeNodes(dmnDefinitions, new HashMap<JSITImport, JSITDefinitions>(), false, (a, b) -> {}).stream().map(e -> this.getDRGElement(e.getNode())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        };
        MainJs.unmarshall((String)dmnXml, (String)"", (DMN12UnmarshallCallback)jsCallback);
    }

    public void getDMNDefinitions(String dmnXml, ServiceCallback<JSITDefinitions> callback) {
        DMN12UnmarshallCallback jsCallback = dmn12 -> {
            JSITDefinitions dmnDefinitions = (JSITDefinitions)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)dmn12));
            callback.onSuccess((Object)dmnDefinitions);
        };
        MainJs.unmarshall((String)dmnXml, (String)"", (DMN12UnmarshallCallback)jsCallback);
    }

    public void getWbDefinitions(String dmnXml, ServiceCallback<Definitions> callback) {
        DMN12UnmarshallCallback jsCallback = dmn12 -> {
            JSITDefinitions dmnDefinitions = (JSITDefinitions)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)dmn12));
            HashMap<JSITImport, JSITDefinitions> importDefinitions = new HashMap<JSITImport, JSITDefinitions>();
            HashMap<JSITImport, PMMLDocumentMetadata> pmmlDocuments = new HashMap<JSITImport, PMMLDocumentMetadata>();
            Definitions wbDefinitions = DefinitionsConverter.wbFromDMN(dmnDefinitions, importDefinitions, pmmlDocuments);
            callback.onSuccess((Object)wbDefinitions);
        };
        try {
            MainJs.unmarshall((String)dmnXml, (String)"", (DMN12UnmarshallCallback)jsCallback);
        }
        catch (Exception e) {
            callback.onError(new ClientRuntimeError(e.getMessage()));
        }
    }

    private Optional<DRGElement> getDRGElement(Node node) {
        Object objectDefinition = DefinitionUtils.getElementDefinition((Element)node);
        if (objectDefinition instanceof DRGElement) {
            return Optional.of((DRGElement)objectDefinition);
        }
        return Optional.empty();
    }
}

