/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes;

import com.ait.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.Association;
import org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.client.marshaller.common.IdUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.JsInteropUtils;
import org.kie.workbench.common.dmn.client.marshaller.converters.dd.PointUtils;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIBounds;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIPoint;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAssociation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAuthorityRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBusinessKnowledgeModel;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeSource;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
public class NodeConnector {
    private final FactoryManager factoryManager;
    static final double CENTRE_TOLERANCE = 1.0;
    private static final String INFO_REQ_ID = BindableAdapterUtils.getDefinitionId(InformationRequirement.class);
    private static final String KNOWLEDGE_REQ_ID = BindableAdapterUtils.getDefinitionId(KnowledgeRequirement.class);
    private static final String AUTH_REQ_ID = BindableAdapterUtils.getDefinitionId(AuthorityRequirement.class);
    private static final String ASSOCIATION_ID = BindableAdapterUtils.getDefinitionId(Association.class);

    @Inject
    public NodeConnector(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    void connect(JSIDMNDiagram dmnDiagram, List<JSIDMNEdge> edges, List<JSITAssociation> associations, List<NodeEntry> nodeEntries, boolean isDMNDIPresent) {
        Map<String, List<NodeEntry>> entriesById = this.makeNodeIndex(nodeEntries);
        String diagramId = dmnDiagram.getId();
        for (NodeEntry nodeEntry : nodeEntries) {
            JSITDMNElement element = nodeEntry.getDmnElement();
            Node node = nodeEntry.getNode();
            if (nodeEntry.isIncluded()) continue;
            if (JSITDecision.instanceOf((Object)element)) {
                JSITDecision decision = (JSITDecision)Js.uncheckedCast((Object)element);
                List jsiInformationRequirements = decision.getInformationRequirement();
                for (int i = 0; i < jsiInformationRequirements.size(); ++i) {
                    JSITInformationRequirement ir = (JSITInformationRequirement)Js.uncheckedCast(jsiInformationRequirements.get(i));
                    this.connectEdgeToNodes(INFO_REQ_ID, (JSITDMNElement)ir, ir.getRequiredInput(), entriesById, diagramId, edges, isDMNDIPresent, node);
                    this.connectEdgeToNodes(INFO_REQ_ID, (JSITDMNElement)ir, ir.getRequiredDecision(), entriesById, diagramId, edges, isDMNDIPresent, node);
                }
                List jsiKnowledgeRequirements = decision.getKnowledgeRequirement();
                for (int i = 0; i < jsiKnowledgeRequirements.size(); ++i) {
                    JSITKnowledgeRequirement kr = (JSITKnowledgeRequirement)Js.uncheckedCast(jsiKnowledgeRequirements.get(i));
                    this.connectEdgeToNodes(KNOWLEDGE_REQ_ID, (JSITDMNElement)kr, kr.getRequiredKnowledge(), entriesById, diagramId, edges, isDMNDIPresent, node);
                }
                List jsiAuthorityRequirements = decision.getAuthorityRequirement();
                for (int i = 0; i < jsiAuthorityRequirements.size(); ++i) {
                    JSITAuthorityRequirement ar = (JSITAuthorityRequirement)Js.uncheckedCast(jsiAuthorityRequirements.get(i));
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredAuthority(), entriesById, diagramId, edges, isDMNDIPresent, node);
                }
                continue;
            }
            if (JSITBusinessKnowledgeModel.instanceOf((Object)element)) {
                JSITBusinessKnowledgeModel bkm = (JSITBusinessKnowledgeModel)Js.uncheckedCast((Object)element);
                List jsiKnowledgeRequirements = bkm.getKnowledgeRequirement();
                for (int i = 0; i < jsiKnowledgeRequirements.size(); ++i) {
                    JSITKnowledgeRequirement kr = (JSITKnowledgeRequirement)Js.uncheckedCast(jsiKnowledgeRequirements.get(i));
                    this.connectEdgeToNodes(KNOWLEDGE_REQ_ID, (JSITDMNElement)kr, kr.getRequiredKnowledge(), entriesById, diagramId, edges, isDMNDIPresent, node);
                }
                List jsiAuthorityRequirements = bkm.getAuthorityRequirement();
                for (int i = 0; i < jsiAuthorityRequirements.size(); ++i) {
                    JSITAuthorityRequirement ar = (JSITAuthorityRequirement)Js.uncheckedCast(jsiAuthorityRequirements.get(i));
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredAuthority(), entriesById, diagramId, edges, isDMNDIPresent, node);
                }
                continue;
            }
            if (JSITKnowledgeSource.instanceOf((Object)element)) {
                JSITKnowledgeSource ks = (JSITKnowledgeSource)Js.uncheckedCast((Object)element);
                List jsiAuthorityRequirements = ks.getAuthorityRequirement();
                for (int i = 0; i < jsiAuthorityRequirements.size(); ++i) {
                    JSITAuthorityRequirement ar = (JSITAuthorityRequirement)Js.uncheckedCast(jsiAuthorityRequirements.get(i));
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredInput(), entriesById, diagramId, edges, isDMNDIPresent, node);
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredDecision(), entriesById, diagramId, edges, isDMNDIPresent, node);
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredAuthority(), entriesById, diagramId, edges, isDMNDIPresent, node);
                }
                continue;
            }
            if (!JSITDecisionService.instanceOf((Object)element)) continue;
            JSITDecisionService ds = (JSITDecisionService)Js.uncheckedCast((Object)element);
            List encapsulatedDecisions = ds.getEncapsulatedDecision();
            JsInteropUtils.forEach(encapsulatedDecisions, er -> {
                String reqInputID = this.getId((JSITDMNElementReference)er);
                this.getNode(nodeEntry, reqInputID, entriesById).ifPresent(requiredNode -> this.connectDSChildEdge(node, (Node)requiredNode));
            });
            List outputDecisions = ds.getOutputDecision();
            JsInteropUtils.forEach(outputDecisions, er -> {
                String reqInputID = this.getId((JSITDMNElementReference)er);
                this.getNode(nodeEntry, reqInputID, entriesById).ifPresent(requiredNode -> this.connectDSChildEdge(node, (Node)requiredNode));
            });
        }
        JsInteropUtils.forEach(associations, association -> {
            boolean targetPresent;
            String sourceId = this.getId(association.getSourceRef());
            String targetId = this.getId(association.getTargetRef());
            List source = (List)entriesById.get(sourceId);
            List target = (List)entriesById.get(targetId);
            boolean sourcePresent = source != null && source.size() > 0;
            boolean bl = targetPresent = target != null && target.size() > 0;
            if (sourcePresent && targetPresent) {
                NodeEntry sourceEntry = (NodeEntry)source.get(0);
                NodeEntry targetEntry = (NodeEntry)target.get(0);
                Node sourceNode = sourceEntry.getNode();
                Node targetNode = targetEntry.getNode();
                Edge myEdge = this.factoryManager.newElement(diagramId + "#" + association.getId(), ASSOCIATION_ID).asEdge();
                ViewConnector connectionContent = (ViewConnector)myEdge.getContent();
                Id id = new Id(association.getId());
                Description description = new Description(association.getDescription());
                Association definition = new Association(id, description);
                this.connectEdge(myEdge, sourceNode, targetNode);
                connectionContent.setDefinition((Object)definition);
                connectionContent.setTargetConnection((Connection)MagnetConnection.Builder.atCenter((Element)targetNode));
                connectionContent.setSourceConnection((Connection)MagnetConnection.Builder.atCenter((Element)sourceNode));
            }
        });
    }

    private Optional<Node> getNode(NodeEntry decisionServiceEntry, String internalDMNElementId, Map<String, List<NodeEntry>> entriesById) {
        JSIBounds decisionServiceBounds = decisionServiceEntry.getDmnShape().getBounds();
        for (Map.Entry<String, List<NodeEntry>> entry : entriesById.entrySet()) {
            String id = entry.getKey();
            List<NodeEntry> entries = entry.getValue();
            if (!id.contains(internalDMNElementId)) continue;
            for (NodeEntry nodeEntry : entries) {
                boolean innerY;
                JSIBounds nodeBounds = nodeEntry.getDmnShape().getBounds();
                boolean b = nodeBounds.getX() + nodeBounds.getWidth() < decisionServiceBounds.getX() + decisionServiceBounds.getWidth();
                boolean b1 = nodeBounds.getX() > decisionServiceBounds.getX();
                boolean innerX = b1 && b;
                boolean b2 = nodeBounds.getY() + nodeBounds.getHeight() < decisionServiceBounds.getY() + decisionServiceBounds.getHeight();
                boolean b3 = nodeBounds.getY() > decisionServiceBounds.getY();
                boolean bl = innerY = b2 && b3;
                if (!innerX || !innerY) continue;
                return Optional.of(nodeEntry.getNode());
            }
        }
        return Optional.empty();
    }

    private Map<String, List<NodeEntry>> makeNodeIndex(List<NodeEntry> nodeEntries) {
        HashMap<String, List<NodeEntry>> map = new HashMap<String, List<NodeEntry>>();
        nodeEntries.forEach(nodeEntry -> {
            String dmnElementId = nodeEntry.getDmnElement().getId();
            map.putIfAbsent(dmnElementId, new ArrayList());
            ((List)map.get(dmnElementId)).add(nodeEntry);
        });
        return map;
    }

    private void connectDSChildEdge(Node dsNode, Node requiredNode) {
        String uuid = dsNode.getUUID() + "er" + requiredNode.getUUID();
        EdgeImpl myEdge = new EdgeImpl(uuid);
        myEdge.setContent((Object)new Child());
        this.connectEdge((Edge)myEdge, dsNode, requiredNode);
    }

    private String getId(JSITDMNElementReference elementReference) {
        return Optional.ofNullable(elementReference).map(ref -> {
            String href = elementReference.getHref();
            return href.contains("#") ? href.substring(href.indexOf(35) + 1) : href;
        }).orElse("");
    }

    void connectEdgeToNodes(String connectorTypeId, JSITDMNElement jsiDMNElement, JSITDMNElementReference jsiDMNElementReference, Map<String, List<NodeEntry>> entriesById, String diagramId, List<JSIDMNEdge> edges, boolean isDMNDIPresent, Node currentNode) {
        String reqInputID = this.getId(jsiDMNElementReference);
        List<NodeEntry> nodeEntries = entriesById.get(reqInputID);
        if (nodeEntries == null || nodeEntries.isEmpty()) {
            return;
        }
        Optional<JSIDMNEdge> existingEdge = this.findExistingEdge(jsiDMNElement, edges);
        if (!isDMNDIPresent) {
            NodeEntry nodeEntry = nodeEntries.get(0);
            Node requiredNode = nodeEntry.getNode();
            View view = (View)requiredNode.getContent();
            double viewWidth = view.getBounds().getWidth();
            double viewHeight = view.getBounds().getHeight();
            this.connectWbEdge(connectorTypeId, diagramId, currentNode, requiredNode, this.newEdge(viewWidth / 2.0, viewHeight / 2.0), this.uuid());
        } else if (existingEdge.isPresent()) {
            JSIDMNEdge edge = (JSIDMNEdge)Js.uncheckedCast((Object)existingEdge.get());
            Optional<Node> requiredNode = this.getSourceNode(edge, nodeEntries);
            String id = edge.getDmnElementRef().getLocalPart();
            String currentNodeId = ((DRGElement)((Definition)currentNode.getContent()).getDefinition()).getContentDefinitionId();
            if (this.isEdgeConnectedWithNode(edge, currentNode, entriesById.get(currentNodeId))) {
                this.connectWbEdge(connectorTypeId, diagramId, currentNode, requiredNode.get(), edge, id);
            }
        }
    }

    boolean isEdgeConnectedWithNode(JSIDMNEdge edge, Node currentNode, List<NodeEntry> nodeEntries) {
        Optional<Node> targetNode = this.getTargetNode(edge, nodeEntries);
        Optional<Node> sourceNode = this.getSourceNode(edge, nodeEntries);
        return targetNode.isPresent() && Objects.equals(targetNode.get(), currentNode) || sourceNode.isPresent() && Objects.equals(sourceNode.get(), currentNode);
    }

    private Optional<JSIDMNEdge> findExistingEdge(JSITDMNElement dmnElement, List<JSIDMNEdge> edges) {
        return edges.stream().filter(e -> Objects.equals(e.getDmnElementRef().getLocalPart(), dmnElement.getId())).findFirst();
    }

    void connectWbEdge(String connectorTypeId, String diagramId, Node currentNode, Node requiredNode, JSIDMNEdge dmnEdge, String id) {
        String prefixedId = IdUtils.getPrefixedId(diagramId, id);
        Edge wbEdge = this.factoryManager.newElement(prefixedId, connectorTypeId).asEdge();
        ViewConnector connectionContent = (ViewConnector)wbEdge.getContent();
        this.connectEdge(wbEdge, requiredNode, currentNode);
        this.setConnectionMagnets(wbEdge, connectionContent, dmnEdge);
    }

    JSIDMNEdge newEdge(double x, double y) {
        JSIDMNEdge dmnEdge = new JSIDMNEdge();
        JSIPoint point = new JSIPoint();
        point.setX(x);
        point.setY(y);
        dmnEdge.addAllWaypoint(new JSIPoint[]{point, point});
        return dmnEdge;
    }

    void connectEdge(Edge edge, Node source, Node target) {
        edge.setSourceNode(source);
        edge.setTargetNode(target);
        source.getOutEdges().add(edge);
        target.getInEdges().add(edge);
    }

    void setConnectionMagnets(Edge edge, ViewConnector connectionContent, JSIDMNEdge jsidmnEdge) {
        JSIDMNEdge e = (JSIDMNEdge)Js.uncheckedCast((Object)jsidmnEdge);
        JSIPoint source = (JSIPoint)Js.uncheckedCast(e.getWaypoint().get(0));
        Node sourceNode = edge.getSourceNode();
        if (null != sourceNode) {
            this.setConnectionMagnet(sourceNode, source, arg_0 -> ((ViewConnector)connectionContent).setSourceConnection(arg_0), this.isSourceAutoConnectionEdge(jsidmnEdge));
        }
        JSIPoint target = (JSIPoint)Js.uncheckedCast(e.getWaypoint().get(e.getWaypoint().size() - 1));
        Node targetNode = edge.getTargetNode();
        if (null != targetNode) {
            this.setConnectionMagnet(targetNode, target, arg_0 -> ((ViewConnector)connectionContent).setTargetConnection(arg_0), this.isTargetAutoConnectionEdge(jsidmnEdge));
        }
        if (e.getWaypoint().size() > 2) {
            connectionContent.setControlPoints((ControlPoint[])e.getWaypoint().subList(1, e.getWaypoint().size() - 1).stream().map(p -> ControlPoint.build((org.kie.workbench.common.stunner.core.graph.content.view.Point2D)PointUtils.dmndiPointToPoint2D(p))).toArray(ControlPoint[]::new));
        }
    }

    protected boolean isSourceAutoConnectionEdge(JSIDMNEdge jsidmnEdge) {
        return this.isAutoConnection(jsidmnEdge, "-AUTO-SOURCE");
    }

    protected boolean isTargetAutoConnectionEdge(JSIDMNEdge jsidmnEdge) {
        return this.isAutoConnection(jsidmnEdge, "-AUTO-TARGET");
    }

    protected boolean isAutoConnection(JSIDMNEdge jsidmnEdge, String autoConnectionID) {
        String dmnEdgeID = jsidmnEdge.getId();
        if (dmnEdgeID != null) {
            return dmnEdgeID.contains(autoConnectionID);
        }
        return false;
    }

    private void setConnectionMagnet(Node<View<?>, Edge> node, JSIPoint magnetPoint, Consumer<Connection> connectionConsumer, Boolean isAutoConnection) {
        double viewHeight;
        double viewWidth;
        double magnetRelativeY;
        View view = (View)node.getContent();
        double viewX = PointUtils.xOfBound(PointUtils.upperLeftBound(view));
        double viewY = PointUtils.yOfBound(PointUtils.upperLeftBound(view));
        double magnetRelativeX = magnetPoint.getX() - viewX;
        MagnetConnection connection = this.isCentre(magnetRelativeX, magnetRelativeY = magnetPoint.getY() - viewY, viewWidth = view.getBounds().getWidth(), viewHeight = view.getBounds().getHeight()) ? MagnetConnection.Builder.atCenter(node) : MagnetConnection.Builder.at((double)magnetRelativeX, (double)magnetRelativeY);
        connection.setAuto(isAutoConnection.booleanValue());
        connectionConsumer.accept((Connection)connection);
    }

    private boolean isCentre(double magnetRelativeX, double magnetRelativeY, double viewWidth, double viewHeight) {
        return Math.abs(viewWidth / 2.0 - magnetRelativeX) < 1.0 && Math.abs(viewHeight / 2.0 - magnetRelativeY) < 1.0;
    }

    Optional<Node> getSourceNode(JSIDMNEdge jsidmnEdge, List<NodeEntry> entries) {
        if (entries.size() == 1) {
            return Optional.of(entries.get(0).getNode());
        }
        JSIPoint jsiSource = (JSIPoint)Js.uncheckedCast(jsidmnEdge.getWaypoint().get(0));
        Point2D source = this.createPoint(jsiSource);
        return this.getNodeFromPoint(source, entries);
    }

    Point2D createPoint(JSIPoint point) {
        return new Point2D(point.getX(), point.getY());
    }

    Optional<Node> getTargetNode(JSIDMNEdge jsidmnEdge, List<NodeEntry> entries) {
        if (entries.size() == 1) {
            return Optional.of(entries.get(0).getNode());
        }
        JSIPoint jsiTarget = (JSIPoint)Js.uncheckedCast(jsidmnEdge.getWaypoint().get(1));
        Point2D source = this.createPoint(jsiTarget);
        return this.getNodeFromPoint(source, entries);
    }

    Optional<Node> getNodeFromPoint(Point2D point, List<NodeEntry> entries) {
        if (entries.size() == 1) {
            return Optional.of(entries.get(0).getNode());
        }
        HashMap<Point2D, NodeEntry> entriesByPoint2D = new HashMap<Point2D, NodeEntry>();
        for (NodeEntry entry : entries) {
            JSIBounds bounds = entry.getDmnShape().getBounds();
            double centerX = bounds.getX() + bounds.getWidth() / 2.0;
            double centerY = bounds.getY() + bounds.getHeight() / 2.0;
            entriesByPoint2D.put(new Point2D(centerX, centerY), entry);
        }
        Point2D nearest = (Point2D)Collections.min(entriesByPoint2D.keySet(), (point1, point2) -> {
            Double distance1 = point.distance(point1);
            Double distance2 = point.distance(point2);
            return distance1.compareTo(distance2);
        });
        if (!this.isPointInsideNode((NodeEntry)entriesByPoint2D.get(nearest), point)) {
            return Optional.empty();
        }
        return Optional.of(((NodeEntry)entriesByPoint2D.get(nearest)).getNode());
    }

    boolean isPointInsideNode(NodeEntry node, Point2D point) {
        JSIBounds bounds = node.getDmnShape().getBounds();
        double width = bounds.getX() + bounds.getWidth();
        double height = bounds.getY() + bounds.getHeight();
        return point.getX() <= width + 1.0 && point.getX() >= bounds.getX() - 1.0 && point.getY() <= height + 1.0 && point.getY() >= bounds.getY() - 1.0;
    }

    String uuid() {
        return UUID.uuid();
    }
}

