/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.client.marshaller.common.JsInteropUtils;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsClientHelper;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeConnector;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntriesBuilder;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.StunnerConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAssociation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITTextAnnotation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;

@Dependent
public class NodeEntriesFactory {
    private final StunnerConverter nodeFactory;
    private final NodeConnector nodeConnector;
    private final DMNMarshallerImportsClientHelper dmnMarshallerImportsHelper;

    @Inject
    public NodeEntriesFactory(StunnerConverter nodeFactory, NodeConnector nodeConnector, DMNMarshallerImportsClientHelper dmnMarshallerImportsHelper) {
        this.nodeFactory = nodeFactory;
        this.nodeConnector = nodeConnector;
        this.dmnMarshallerImportsHelper = dmnMarshallerImportsHelper;
    }

    public List<NodeEntry> makeNodes(JSITDefinitions definitions, Map<JSITImport, JSITDefinitions> importDefinitions, boolean isDMNDIPresent, BiConsumer<String, HasComponentWidths> componentWidthsConsumer) {
        List dmnDiagrams = definitions.getDMNDI().getDMNDiagram();
        List<NodeEntry> nodeEntries = this.entriesBuilder().withShapesByDiagramId(this.getShapesByDiagramId(definitions)).withDRGElements(this.getDRGElements(definitions)).withIncludedDRGElements(this.getIncludedDRGElements(importDefinitions)).withTextAnnotations(this.getTextAnnotations(definitions)).withDMNDiagrams(dmnDiagrams).withComponentWidthsConsumer(componentWidthsConsumer).buildEntries();
        nodeEntries.sort((n1, n2) -> {
            if (JSITDecisionService.instanceOf((Object)n1.getDmnElement())) {
                return -1;
            }
            if (JSITDecisionService.instanceOf((Object)n2.getDmnElement())) {
                return 1;
            }
            return 0;
        });
        JsInteropUtils.forEach(dmnDiagrams, dmnDiagram -> {
            String diagramId = dmnDiagram.getId();
            List<JSIDMNEdge> edges = this.getEdges((JSIDMNDiagram)dmnDiagram);
            List<JSITAssociation> associations = this.getAssociations(definitions);
            List<NodeEntry> nodes = nodeEntries.stream().filter(n -> Objects.equals(n.getDiagramId(), diagramId)).collect(Collectors.toList());
            this.nodeConnector.connect((JSIDMNDiagram)dmnDiagram, edges, associations, nodes, isDMNDIPresent);
        });
        return nodeEntries;
    }

    private NodeEntriesBuilder entriesBuilder() {
        return new NodeEntriesBuilder(this.nodeFactory);
    }

    private List<JSIDMNEdge> getEdges(JSIDMNDiagram dmnDiagram) {
        ArrayList<JSIDMNEdge> edges = new ArrayList<JSIDMNEdge>();
        List dmnDiagramElements = dmnDiagram.getDMNDiagramElement();
        JsInteropUtils.forEach(dmnDiagramElements, dmnDiagramElement -> {
            if (JSIDMNEdge.instanceOf((Object)dmnDiagramElement)) {
                JSIDMNEdge jsiEdge = (JSIDMNEdge)Js.uncheckedCast((Object)dmnDiagramElement);
                edges.add(jsiEdge);
            }
        });
        return edges;
    }

    private List<JSITAssociation> getAssociations(JSITDefinitions definitions) {
        ArrayList<JSITAssociation> associations = new ArrayList<JSITAssociation>();
        List artifacts = definitions.getArtifact();
        JsInteropUtils.forEach(artifacts, artifact -> {
            if (JSITAssociation.instanceOf((Object)artifact)) {
                JSITAssociation association = (JSITAssociation)Js.uncheckedCast((Object)artifact);
                associations.add(association);
            }
        });
        return associations;
    }

    private Map<JSIDMNShape, String> getShapesByDiagramId(JSITDefinitions definitions) {
        HashMap<JSIDMNShape, String> dmnShapesByDiagramId = new HashMap<JSIDMNShape, String>();
        List diagrams = definitions.getDMNDI().getDMNDiagram();
        JsInteropUtils.forEach(diagrams, diagram -> {
            String diagramId = diagram.getId();
            List diagramElements = diagram.getDMNDiagramElement();
            JsInteropUtils.forEach(diagramElements, diagramElement -> {
                if (JSIDMNShape.instanceOf((Object)diagramElement)) {
                    JSIDMNShape shape = (JSIDMNShape)Js.uncheckedCast((Object)diagramElement);
                    dmnShapesByDiagramId.put(shape, diagramId);
                }
            });
        });
        return dmnShapesByDiagramId;
    }

    private List<JSITDRGElement> getDRGElements(JSITDefinitions definitions) {
        return definitions.getDrgElement();
    }

    private List<JSITDRGElement> getIncludedDRGElements(Map<JSITImport, JSITDefinitions> importDefinitions) {
        return this.dmnMarshallerImportsHelper.getImportedDRGElements(importDefinitions);
    }

    private List<JSITTextAnnotation> getTextAnnotations(JSITDefinitions definitions) {
        ArrayList<JSITTextAnnotation> textAnnotations = new ArrayList<JSITTextAnnotation>();
        List artifacts = definitions.getArtifact();
        JsInteropUtils.forEach(artifacts, artifact -> {
            if (JSITTextAnnotation.instanceOf((Object)artifact)) {
                JSITTextAnnotation annotation = (JSITTextAnnotation)Js.uncheckedCast((Object)artifact);
                textAnnotations.add(annotation);
            }
        });
        return textAnnotations;
    }
}

