/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import elemental2.dom.DomGlobal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.Candidate;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.FEELLanguageService;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.Variable;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

@ApplicationScoped
public class MonacoFEELSuggestions {
    private final DMNGraphUtils dmnGraphUtils;
    private final FEELLanguageService feelLanguageService;

    @Inject
    public MonacoFEELSuggestions(DMNGraphUtils dmnGraphUtils, FEELLanguageService feelLanguageService) {
        this.dmnGraphUtils = dmnGraphUtils;
        this.feelLanguageService = feelLanguageService;
    }

    public List<Candidate> getCandidates(String expression, FEELLanguageService.Position position) {
        try {
            return this.feelLanguageService.getCandidates(expression, this.getNodesVariables(), position);
        }
        catch (Exception e) {
            this.warn("[FEELLanguageService] Error: Candidates could not be processed.");
            return new ArrayList<Candidate>();
        }
    }

    private List<Variable> getNodesVariables() {
        return this.getDiagramDefinitions().stream().map(this::asVariable).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Variable> asVariable(Object definition) {
        if (definition instanceof NamedElement) {
            return Optional.of(new Variable(this.getName(definition), this.getType(definition)));
        }
        return Optional.empty();
    }

    private String getName(Object definition) {
        NamedElement namedElement = (NamedElement)definition;
        Name name = namedElement.getName();
        return name.getValue();
    }

    private Type getType(Object definition) {
        try {
            HasVariable hasVariable = (HasVariable)definition;
            String localPart = hasVariable.getVariable().getTypeRef().getLocalPart();
            return BuiltInType.determineTypeFromName((String)localPart);
        }
        catch (Exception e) {
            return BuiltInType.UNKNOWN;
        }
    }

    private List<Object> getDiagramDefinitions() {
        return this.dmnGraphUtils.getNodeStream().map(Element::getContent).filter(c -> c instanceof Definition).map(c -> (Definition)c).map(Definition::getDefinition).collect(Collectors.toList());
    }

    void warn(String message) {
        DomGlobal.console.warn(new Object[]{message});
    }
}

