/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELInitializer;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELSuggestions;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.Candidate;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.CompletionItemKind;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.FEELLanguageService;

@ApplicationScoped
public class MonacoSuggestionsPropertyFactory {
    static final String KIND_KEY = "kind";
    static final String INSERT_TEXT_RULES_KEY = "insertTextRules";
    static final String LABEL_KEY = "label";
    static final String INSERT_TEXT_KEY = "insertText";
    static final String SORT_TEXT_KEY = "sortText";
    private final List<Candidate> DEFAULT_KEYWORDS = this.getAllKeywords();
    private final List<Candidate> DEFAULT_FUNCTIONS = this.getAllFunctions();
    private final MonacoFEELSuggestions monacoFEELSuggestions;

    @Inject
    public MonacoSuggestionsPropertyFactory(MonacoFEELSuggestions monacoFEELSuggestions) {
        this.monacoFEELSuggestions = monacoFEELSuggestions;
    }

    public JSONArray create(String expression, FEELLanguageService.Position position) {
        JSONArray jsonArray = this.makeJSONArray();
        this.pushAll(jsonArray, this.getSuggestions(expression, position));
        return jsonArray;
    }

    private List<Candidate> getSuggestions(String expression, FEELLanguageService.Position position) {
        ArrayList<Candidate> suggestions = new ArrayList<Candidate>();
        List<Candidate> feelCandidates = this.monacoFEELSuggestions.getCandidates(expression, position);
        ArrayList<Candidate> functions = new ArrayList<Candidate>(this.DEFAULT_FUNCTIONS);
        ArrayList<Candidate> keywords = new ArrayList<Candidate>(this.DEFAULT_KEYWORDS);
        block4: for (Candidate candidate : feelCandidates) {
            switch (candidate.getKind()) {
                case Function: {
                    suggestions.add(this.removeIfPresent(functions, candidate));
                    continue block4;
                }
                case Keyword: {
                    suggestions.add(this.removeIfPresent(keywords, candidate));
                    continue block4;
                }
            }
            suggestions.add(candidate);
        }
        suggestions.addAll(functions);
        suggestions.addAll(keywords);
        return suggestions;
    }

    private Candidate removeIfPresent(List<Candidate> candidates, Candidate candidate) {
        Candidate element;
        int index = candidates.indexOf(candidate);
        if (index != -1) {
            element = candidates.get(index);
            candidates.remove(index);
        } else {
            element = candidate;
        }
        return element;
    }

    JSONValue getSuggestion(Candidate candidate, int index) {
        JSONObject suggestion = this.makeJSONObject();
        int completionItemKindFunction = candidate.getKind().getValue();
        int completionItemInsertTextRuleInsertAsSnippet = 4;
        String sortTextValue = NumberFormat.getFormat((String)"#0000").format((double)index);
        suggestion.put(KIND_KEY, this.makeJSONNumber(completionItemKindFunction));
        suggestion.put(INSERT_TEXT_RULES_KEY, this.makeJSONNumber(4));
        suggestion.put(LABEL_KEY, (JSONValue)this.makeJSONString(candidate.getLabel()));
        suggestion.put(INSERT_TEXT_KEY, (JSONValue)this.makeJSONString(candidate.getInsertText()));
        suggestion.put(SORT_TEXT_KEY, (JSONValue)this.makeJSONString(sortTextValue));
        return suggestion;
    }

    private void pushAll(JSONArray jsArray, List<Candidate> candidates) {
        for (int index = 0; index < candidates.size(); ++index) {
            this.push(jsArray, this.getSuggestion(candidates.get(index), index));
        }
    }

    void push(JSONArray jsonArray, JSONValue jsonValue) {
        jsonArray.set(jsonArray.size(), jsonValue);
    }

    JSONArray makeJSONArray() {
        return new JSONArray();
    }

    JSONString makeJSONString(String value) {
        return new JSONString(value);
    }

    JSONValue makeJSONNumber(int value) {
        return new JSONNumber((double)value);
    }

    JSONObject makeJSONObject() {
        return new JSONObject();
    }

    private List<Candidate> getAllKeywords() {
        return MonacoFEELInitializer.FEEL_RESERVED_KEYWORDS.stream().map(this::makeKeywordCandidate).collect(Collectors.toList());
    }

    private List<Candidate> getAllFunctions() {
        return Arrays.asList(this.makeFunctionCandidate("abs(duration)", "abs($1)"), this.makeFunctionCandidate("abs(number)", "abs($1)"), this.makeFunctionCandidate("after(range, value)", "after($1, $2)"), this.makeFunctionCandidate("after(range1, range2)", "after($1, $2)"), this.makeFunctionCandidate("after(value, range)", "after($1, $2)"), this.makeFunctionCandidate("after(value1, value2)", "after($1, $2)"), this.makeFunctionCandidate("all(b)", "all($1)"), this.makeFunctionCandidate("all(list)", "all($1)"), this.makeFunctionCandidate("any(b)", "any($1)"), this.makeFunctionCandidate("any(list)", "any($1)"), this.makeFunctionCandidate("append(list, item)", "append($1, $2)"), this.makeFunctionCandidate("before(range, value)", "before($1, $2)"), this.makeFunctionCandidate("before(range1, range2)", "before($1, $2)"), this.makeFunctionCandidate("before(value, range)", "before($1, $2)"), this.makeFunctionCandidate("before(value1, value2)", "before($1, $2)"), this.makeFunctionCandidate("ceiling(n)", "ceiling($1)"), this.makeFunctionCandidate("code(value)", "code($1)"), this.makeFunctionCandidate("coincides(range1, range2)", "coincides($1, $2)"), this.makeFunctionCandidate("coincides(value1, value2)", "coincides($1, $2)"), this.makeFunctionCandidate("concatenate(list)", "concatenate($1)"), this.makeFunctionCandidate("contains(string, match)", "contains($1, $2)"), this.makeFunctionCandidate("count(c)", "count($1)"), this.makeFunctionCandidate("count(list)", "count($1)"), this.makeFunctionCandidate("date and time(date, time)", "date and time($1, $2)"), this.makeFunctionCandidate("date and time(from)", "date and time($1)"), this.makeFunctionCandidate("date and time(year, month, day, hour, minute, second)", "date and time($1, $2, $3, $4, $5, $6)"), this.makeFunctionCandidate("date and time(year, month, day, hour, minute, second, hour offset)", "date and time($1, $2, $3, $4, $5, $6, $7)"), this.makeFunctionCandidate("date and time(year, month, day, hour, minute, second, timezone)", "date and time($1, $2, $3, $4, $5, $6, $7)"), this.makeFunctionCandidate("date(from)", "date($1)"), this.makeFunctionCandidate("date(year, month, day)", "date($1, $2, $3)"), this.makeFunctionCandidate("day of week(date)", "day of week($1)"), this.makeFunctionCandidate("day of year(date)", "day of year($1)"), this.makeFunctionCandidate("decimal(n, scale)", "decimal($1, $2)"), this.makeFunctionCandidate("decision table(ctx, outputs, input expression list, input values list, output values, rule list, hit policy, default output value)", "decision table($1, $2, $3, $4, $5, $6, $7, $8)"), this.makeFunctionCandidate("distinct values(list)", "distinct values($1)"), this.makeFunctionCandidate("duration(from)", "duration($1)"), this.makeFunctionCandidate("during(range1, range2)", "during($1, $2)"), this.makeFunctionCandidate("during(value, range)", "during($1, $2)"), this.makeFunctionCandidate("ends with(string, match)", "ends with($1, $2)"), this.makeFunctionCandidate("even(number)", "even($1)"), this.makeFunctionCandidate("exp(number)", "exp($1)"), this.makeFunctionCandidate("finished by(range, value)", "finished by($1, $2)"), this.makeFunctionCandidate("finished by(range1, range2)", "finished by($1, $2)"), this.makeFunctionCandidate("finishes(range1, range2)", "finishes($1, $2)"), this.makeFunctionCandidate("finishes(value, range)", "finishes($1, $2)"), this.makeFunctionCandidate("flatten(list)", "flatten($1)"), this.makeFunctionCandidate("floor(n)", "floor($1)"), this.makeFunctionCandidate("get entries(m)", "get entries($1)"), this.makeFunctionCandidate("get value(m, key)", "get value($1, $2)"), this.makeFunctionCandidate("includes(range, value)", "includes($1, $2)"), this.makeFunctionCandidate("includes(range1, range2)", "includes($1, $2)"), this.makeFunctionCandidate("index of(list, match)", "index of($1, $2)"), this.makeFunctionCandidate("insert before(list, position, newItem)", "insert before($1, $2, $3)"), this.makeFunctionCandidate("invoke(ctx, namespace, model name, decision name, parameters)", "invoke($1, $2, $3, $4, $5)"), this.makeFunctionCandidate("list contains(list, element)", "list contains($1, $2)"), this.makeFunctionCandidate("log(number)", "log($1)"), this.makeFunctionCandidate("lower case(string)", "lower case($1)"), this.makeFunctionCandidate("matches(input, pattern)", "matches($1, $2)"), this.makeFunctionCandidate("matches(input, pattern, flags)", "matches($1, $2, $3)"), this.makeFunctionCandidate("max(c)", "max($1)"), this.makeFunctionCandidate("max(list)", "max($1)"), this.makeFunctionCandidate("mean(list)", "mean($1)"), this.makeFunctionCandidate("mean(n)", "mean($1)"), this.makeFunctionCandidate("median(list)", "median($1)"), this.makeFunctionCandidate("median(n)", "median($1)"), this.makeFunctionCandidate("meets(range1, range2)", "meets($1, $2)"), this.makeFunctionCandidate("met by(range1, range2)", "met by($1, $2)"), this.makeFunctionCandidate("min(c)", "min($1)"), this.makeFunctionCandidate("min(list)", "min($1)"), this.makeFunctionCandidate("mode(list)", "mode($1)"), this.makeFunctionCandidate("mode(n)", "mode($1)"), this.makeFunctionCandidate("modulo(dividend, divisor)", "modulo($1, $2)"), this.makeFunctionCandidate("month of year(date)", "month of year($1)"), this.makeFunctionCandidate("nn all(b)", "nn all($1)"), this.makeFunctionCandidate("nn all(list)", "nn all($1)"), this.makeFunctionCandidate("nn any(b)", "nn any($1)"), this.makeFunctionCandidate("nn any(list)", "nn any($1)"), this.makeFunctionCandidate("nn count(c)", "nn count($1)"), this.makeFunctionCandidate("nn count(list)", "nn count($1)"), this.makeFunctionCandidate("nn max(c)", "nn max($1)"), this.makeFunctionCandidate("nn max(list)", "nn max($1)"), this.makeFunctionCandidate("nn mean(list)", "nn mean($1)"), this.makeFunctionCandidate("nn mean(n)", "nn mean($1)"), this.makeFunctionCandidate("nn median(list)", "nn median($1)"), this.makeFunctionCandidate("nn median(n)", "nn median($1)"), this.makeFunctionCandidate("nn min(c)", "nn min($1)"), this.makeFunctionCandidate("nn min(list)", "nn min($1)"), this.makeFunctionCandidate("nn mode(list)", "nn mode($1)"), this.makeFunctionCandidate("nn mode(n)", "nn mode($1)"), this.makeFunctionCandidate("nn stddev(list)", "nn stddev($1)"), this.makeFunctionCandidate("nn stddev(n)", "nn stddev($1)"), this.makeFunctionCandidate("nn sum(list)", "nn sum($1)"), this.makeFunctionCandidate("nn sum(n)", "nn sum($1)"), this.makeFunctionCandidate("not(negand)", "not($1)"), this.makeFunctionCandidate("now()", "now()"), this.makeFunctionCandidate("number(from, grouping separator, decimal separator)", "number($1, $2, $3)"), this.makeFunctionCandidate("odd(number)", "odd($1)"), this.makeFunctionCandidate("overlapped after by(range1, range2)", "overlapped after by($1, $2)"), this.makeFunctionCandidate("overlapped before by(range1, range2)", "overlapped before by($1, $2)"), this.makeFunctionCandidate("overlapped by(range1, range2)", "overlapped by($1, $2)"), this.makeFunctionCandidate("overlaps after(range1, range2)", "overlaps after($1, $2)"), this.makeFunctionCandidate("overlaps before(range1, range2)", "overlaps before($1, $2)"), this.makeFunctionCandidate("overlaps(range1, range2)", "overlaps($1, $2)"), this.makeFunctionCandidate("product(list)", "product($1)"), this.makeFunctionCandidate("product(n)", "product($1)"), this.makeFunctionCandidate("remove(list, position)", "remove($1, $2)"), this.makeFunctionCandidate("replace(input, pattern, replacement)", "replace($1, $2, $3)"), this.makeFunctionCandidate("replace(input, pattern, replacement, flags)", "replace($1, $2, $3, $4)"), this.makeFunctionCandidate("reverse(list)", "reverse($1)"), this.makeFunctionCandidate("sort()", "sort()"), this.makeFunctionCandidate("sort(ctx, list, precedes)", "sort($1, $2, $3)"), this.makeFunctionCandidate("sort(list)", "sort($1)"), this.makeFunctionCandidate("split(string, delimiter)", "split($1, $2)"), this.makeFunctionCandidate("split(string, delimiter, flags)", "split($1, $2, $3)"), this.makeFunctionCandidate("sqrt(number)", "sqrt($1)"), this.makeFunctionCandidate("started by(range, value)", "started by($1, $2)"), this.makeFunctionCandidate("started by(range1, range2)", "started by($1, $2)"), this.makeFunctionCandidate("starts with(string, match)", "starts with($1, $2)"), this.makeFunctionCandidate("starts(range1, range2)", "starts($1, $2)"), this.makeFunctionCandidate("starts(value, range)", "starts($1, $2)"), this.makeFunctionCandidate("stddev(list)", "stddev($1)"), this.makeFunctionCandidate("stddev(n)", "stddev($1)"), this.makeFunctionCandidate("string length(string)", "string length($1)"), this.makeFunctionCandidate("string(from)", "string($1)"), this.makeFunctionCandidate("string(mask, p)", "string($1, $2)"), this.makeFunctionCandidate("sublist(list, start position)", "sublist($1, $2)"), this.makeFunctionCandidate("sublist(list, start position, length)", "sublist($1, $2, $3)"), this.makeFunctionCandidate("substring after(string, match)", "substring after($1, $2)"), this.makeFunctionCandidate("substring before(string, match)", "substring before($1, $2)"), this.makeFunctionCandidate("substring(string, start position)", "substring($1, $2)"), this.makeFunctionCandidate("substring(string, start position, length)", "substring($1, $2, $3)"), this.makeFunctionCandidate("sum(list)", "sum($1)"), this.makeFunctionCandidate("sum(n)", "sum($1)"), this.makeFunctionCandidate("time(from)", "time($1)"), this.makeFunctionCandidate("time(hour, minute, second)", "time($1, $2, $3)"), this.makeFunctionCandidate("time(hour, minute, second, offset)", "time($1, $2, $3, $4)"), this.makeFunctionCandidate("today()", "today()"), this.makeFunctionCandidate("union(list)", "union($1)"), this.makeFunctionCandidate("upper case(string)", "upper case($1)"), this.makeFunctionCandidate("week of year(date)", "week of year($1)"), this.makeFunctionCandidate("years and months duration(from, to)", "years and months duration($1, $2)"));
    }

    private Candidate makeKeywordCandidate(String label) {
        return new Candidate(label, CompletionItemKind.Keyword);
    }

    private Candidate makeFunctionCandidate(String label, String insertText) {
        return new Candidate(label, insertText, CompletionItemKind.Function);
    }
}

