/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion.feel;

import com.google.gwt.core.client.GWT;
import com.vmware.antlr4c3.CodeCompletionCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.kie.dmn.feel.gwt.functions.api.FunctionDefinitionStrings;
import org.kie.dmn.feel.gwt.functions.api.FunctionOverrideVariation;
import org.kie.dmn.feel.gwt.functions.client.FEELFunctionProvider;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.ASTBuilderVisitor;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.Candidate;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.CompletionItemKind;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.DisplayNameUtils;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.TypeStackUtils;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.Variable;

@ApplicationScoped
public class FEELLanguageService {
    private static final Set<Integer> IGNORED_TOKENS = Stream.of(43, 54, 49, 47, 1, 40, 31, 52, 46, 33, 32, 34, 23, 38, 35, 50, 22, 27, 29, 37, 53, 25, 36, 45, 39, 18, 42, 21, 41, 28, 30, 26, 24, 44, 51).collect(Collectors.toCollection(HashSet::new));
    private final List<FunctionOverrideVariation> functions = new ArrayList<FunctionOverrideVariation>();
    private final TypeStackUtils typeStackUtils;

    @Inject
    public FEELLanguageService(TypeStackUtils typeStackUtils) {
        this.typeStackUtils = typeStackUtils;
    }

    public List<Candidate> getCandidates(String text, List<Variable> variables, Position position) {
        FEEL_1_1Parser parser = this.getParser(text);
        FEEL_1_1Parser.ExpressionContext parseTree = parser.expression();
        BaseNode astNode = this.getASTNode((ParseTree)parseTree);
        Type type = this.getType(astNode, position);
        List<Candidate> candidateVariables = this.getCandidateVariables(type, variables);
        List<Candidate> candidateKeyword = this.getFeelKeywords((ParseTree)parseTree, parser, position);
        List<Candidate> candidateFunctions = this.getCandidateFunctions(type);
        ArrayList<Candidate> keywords = new ArrayList<Candidate>();
        keywords.addAll(candidateVariables);
        keywords.addAll(candidateFunctions);
        keywords.addAll(candidateKeyword);
        return keywords;
    }

    private List<Candidate> getCandidateVariables(Type type, List<Variable> variables) {
        return variables.stream().filter(v -> v.getType().conformsTo(type)).map(v -> new Candidate(v.getName(), CompletionItemKind.Variable)).collect(Collectors.toList());
    }

    private List<Candidate> getFeelKeywords(ParseTree parseTree, FEEL_1_1Parser parser, Position position) {
        CodeCompletionCore core = new CodeCompletionCore((Parser)parser, null, IGNORED_TOKENS);
        int caretIndex = this.computeTokenIndex(parseTree, position);
        CodeCompletionCore.CandidatesCollection candidates = core.collectCandidates(caretIndex, parser.getContext());
        return this.getCandidateNames(parser, candidates).stream().map(name -> new Candidate((String)name, CompletionItemKind.Keyword)).collect(Collectors.toList());
    }

    FEEL_1_1Parser getParser(String text) {
        return FEELParser.parse(null, (String)text, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), null);
    }

    Type getType(BaseNode astNode, Position position) {
        List<Type> typeStack = this.typeStackUtils.getTypeStack((ASTNode)astNode, position);
        return typeStack.size() == 0 ? BuiltInType.UNKNOWN : typeStack.get(typeStack.size() - 1);
    }

    private List<Candidate> getCandidateFunctions(Type type) {
        ArrayList<Candidate> functions = new ArrayList<Candidate>();
        for (FunctionOverrideVariation function : this.getFunctions()) {
            if (!type.isAssignableValue((Object)BuiltInType.UNKNOWN) && !Objects.equals(function.getReturnType(), type)) continue;
            FunctionDefinitionStrings definitionStrings = function.toHumanReadableStrings();
            String humanReadable = definitionStrings.getHumanReadable();
            String template = definitionStrings.getTemplate();
            functions.add(new Candidate(humanReadable, template, CompletionItemKind.Function));
        }
        return functions;
    }

    private List<FunctionOverrideVariation> getFunctions() {
        if (this.functions.isEmpty()) {
            this.functions.addAll(this.getFunctionOverrideVariations());
        }
        return this.functions;
    }

    public List<FunctionOverrideVariation> getFunctionOverrideVariations() {
        FEELFunctionProvider functionProvider = (FEELFunctionProvider)GWT.create(FEELFunctionProvider.class);
        return functionProvider.getDefinitions();
    }

    BaseNode getASTNode(ParseTree parseTree) {
        return (BaseNode)new ASTBuilderVisitor(Collections.emptyMap(), null).visit(parseTree);
    }

    private List<String> getCandidateNames(FEEL_1_1Parser parser, CodeCompletionCore.CandidatesCollection candidates) {
        ArrayList<String> candidateNames = new ArrayList<String>();
        candidateNames.addAll(DisplayNameUtils.getDisplayName(parser, candidates.tokens));
        candidateNames.addAll(DisplayNameUtils.getDisplayName(parser, candidates.rules));
        candidateNames.addAll(DisplayNameUtils.getDisplayName(parser, candidates.rulePositions));
        return candidateNames;
    }

    private Integer computeTokenIndex(ParseTree parseTree, Position position) {
        if (parseTree instanceof TerminalNode) {
            return this.computeTokenIndexOfTerminalNode((TerminalNode)parseTree, position);
        }
        return this.computeTokenIndexOfChildNode(parseTree, position);
    }

    private Integer computeTokenIndexOfTerminalNode(TerminalNode parseTree, Position position) {
        Token symbol = parseTree.getSymbol();
        int start = symbol.getCharPositionInLine();
        int stop = symbol.getCharPositionInLine() + parseTree.getText().length();
        if (symbol.getLine() == position.line && position.column >= start && position.column <= stop) {
            return symbol.getTokenIndex();
        }
        return 0;
    }

    private Integer computeTokenIndexOfChildNode(ParseTree parseTree, Position position) {
        for (int i = 0; i < parseTree.getChildCount(); ++i) {
            int index = this.computeTokenIndex(parseTree.getChild(i), position);
            if (index == 0) continue;
            return index;
        }
        return 0;
    }

    public static class Position {
        int line;
        int column;

        public Position(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            return this.line == position.line && this.column == position.column;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.column);
        }

        public String toString() {
            return "Position{line=" + this.line + ", column=" + this.column + '}';
        }
    }
}

