/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.decisionservice.parameters;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasValue;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersList;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.widgets.decisionservice.parameters.parametergroup.ParameterGroup;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

@Dependent
@Templated
public class DecisionServiceParametersListWidget
extends Composite
implements HasValue<DecisionServiceParametersList>,
HasEnabled {
    private final ClientTranslationService translationService;
    private final DMNDiagramsSession dmnDiagramsSession;
    private final Elemental2DomUtil util;
    private final ParameterGroup groupEncapsulated;
    private final ParameterGroup groupOutputs;
    private final ParameterGroup groupInputs;
    @DataField(value="decision-service-parameters-widget-container")
    private final HTMLDivElement container;
    private boolean enabled = true;
    private DecisionServiceParametersList value = new DecisionServiceParametersList();

    @Inject
    public DecisionServiceParametersListWidget(ClientTranslationService translationService, Elemental2DomUtil util, DMNDiagramsSession dmnDiagramsSession, ParameterGroup groupEncapsulated, ParameterGroup groupOutputs, ParameterGroup groupInputs, HTMLDivElement container) {
        this.container = container;
        this.dmnDiagramsSession = dmnDiagramsSession;
        this.util = util;
        this.groupEncapsulated = groupEncapsulated;
        this.groupOutputs = groupOutputs;
        this.groupInputs = groupInputs;
        this.translationService = translationService;
    }

    @PostConstruct
    public void setup() {
        this.groupEncapsulated.setHeader(this.translationService.getValue("DecisionServiceParameters.EncapsulatedDecisions"));
        this.groupOutputs.setHeader(this.translationService.getValue("DecisionServiceParameters.Outputs"));
        this.groupInputs.setHeader(this.translationService.getValue("DecisionServiceParameters.Inputs"));
    }

    public DecisionServiceParametersList getValue() {
        return this.value;
    }

    public void setValue(DecisionServiceParametersList documentationLinks) {
        this.setValue(documentationLinks, false);
    }

    public void setValue(DecisionServiceParametersList decisionServiceParametersList, boolean fireEvents) {
        this.value = decisionServiceParametersList;
        this.refresh();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void refresh() {
        this.clear();
        org.kie.workbench.common.stunner.core.graph.Node node = this.getNode(this.getValue().getDecisionService().getContentDefinitionId());
        List outEdges = node.getOutEdges();
        ArrayList<InputData> inputs = new ArrayList<InputData>();
        outEdges.stream().filter(e -> e.getContent() instanceof Child).forEach(e -> this.getTargetDRGElement((Edge<?, ?>)e).ifPresent(drgElement -> {
            org.kie.workbench.common.stunner.core.graph.Node targetNode = e.getTargetNode();
            this.loadDecisionsFromNode(node, targetNode);
            this.loadInputsFromNode(inputs, targetNode);
            this.loadInputsFromOthersDiagrams(inputs, targetNode);
        }));
        this.loadInputsParameters(this.getSortedInputs(inputs));
        this.loadGroupsElements();
    }

    void loadInputsFromOthersDiagrams(List<InputData> inputs, org.kie.workbench.common.stunner.core.graph.Node<View<?>, ?> targetNode) {
        List<org.kie.workbench.common.stunner.core.graph.Node> allNodes = this.dmnDiagramsSession.getNodesFromAllDiagramsWithContentId(this.getDRGElementFromContentDefinition(targetNode).getContentDefinitionId());
        for (org.kie.workbench.common.stunner.core.graph.Node n : allNodes) {
            this.loadInputsFromNode(inputs, n);
        }
    }

    List<InputData> getSortedInputs(List<InputData> inputs) {
        List<InputData> currentItems = this.getCurrentItems(inputs);
        List<InputData> newItems = this.getNewItems(inputs, currentItems);
        currentItems.addAll(newItems);
        return currentItems;
    }

    List<InputData> getCurrentItems(List<InputData> inputs) {
        ArrayList<InputData> sorted = new ArrayList<InputData>();
        this.getValue().getDecisionService().getInputData().forEach(ref -> {
            String href = ref.getHref().replace("#", "");
            Optional<InputData> currentInput = inputs.stream().filter(input -> Objects.equals(input.getId().getValue(), href)).findFirst();
            currentInput.ifPresent(inputData -> sorted.add((InputData)inputData));
        });
        return sorted;
    }

    List<InputData> getNewItems(List<InputData> inputs, List<InputData> currentItems) {
        List<InputData> newItems = inputs.stream().filter(item -> !currentItems.contains(item)).sorted(Comparator.comparing(x -> x.getName().getValue())).collect(Collectors.toList());
        return newItems;
    }

    void loadDecisionsFromNode(org.kie.workbench.common.stunner.core.graph.Node node, org.kie.workbench.common.stunner.core.graph.Node<View<?>, ?> targetNode) {
        if (this.isOutputDecision((View)targetNode.getContent(), (View<DecisionService>)((View)node.getContent()))) {
            this.addDecisionNodeToGroup(this.groupOutputs, targetNode);
        } else {
            this.addDecisionNodeToGroup(this.groupEncapsulated, targetNode);
        }
    }

    void loadGroupsElements() {
        this.container.appendChild((Node)this.util.asHTMLElement(this.groupInputs.getElement()));
        this.container.appendChild((Node)this.util.asHTMLElement(this.groupEncapsulated.getElement()));
        this.container.appendChild((Node)this.util.asHTMLElement(this.groupOutputs.getElement()));
    }

    void loadInputsParameters(List<InputData> inputs) {
        for (InputData input : inputs) {
            InformationItemPrimary variable = input.getVariable();
            String name = input.getName().getValue();
            String type = variable.getTypeRef().getLocalPart();
            this.groupInputs.addParameter(name, type);
        }
    }

    Optional<DRGElement> getTargetDRGElement(Edge<?, ?> e) {
        org.kie.workbench.common.stunner.core.graph.Node targetNode = e.getTargetNode();
        View targetNodeView = (View)targetNode.getContent();
        if (targetNodeView.getDefinition() instanceof DRGElement) {
            return Optional.of((DRGElement)targetNodeView.getDefinition());
        }
        return Optional.empty();
    }

    void clear() {
        RemoveHelper.removeChildren((Element)this.container);
        this.groupEncapsulated.clear();
        this.groupInputs.clear();
        this.groupOutputs.clear();
    }

    org.kie.workbench.common.stunner.core.graph.Node getNode(String contentId) {
        Stream<org.kie.workbench.common.stunner.core.graph.Node> stream = StreamSupport.stream(this.dmnDiagramsSession.getCurrentGraphDiagram().getGraph().nodes().spliterator(), false);
        return this.getElementWithContentId(contentId, stream);
    }

    void loadInputsFromNode(List<InputData> inputs, org.kie.workbench.common.stunner.core.graph.Node<View<?>, ?> targetNode) {
        List<InputData> nodeInputs = this.getInputs(targetNode);
        for (InputData input : nodeInputs) {
            if (!inputs.stream().noneMatch(i -> Objects.equals(i.getId().getValue(), input.getId().getValue()))) continue;
            inputs.add(input);
        }
    }

    void addDecisionNodeToGroup(ParameterGroup group, org.kie.workbench.common.stunner.core.graph.Node<View<?>, ?> node) {
        Decision decision = (Decision)((Definition)node.getContent()).getDefinition();
        InformationItemPrimary variable = decision.getVariable();
        String name = decision.getName().getValue();
        String type = variable.getTypeRef().getLocalPart();
        group.addParameter(name, type);
    }

    List<InputData> getInputs(org.kie.workbench.common.stunner.core.graph.Node<View<?>, ?> targetNode) {
        ArrayList<InputData> inputs = new ArrayList<InputData>();
        List inEdges = targetNode.getInEdges();
        for (Edge e : inEdges) {
            this.getSourceNodeInputData(e).ifPresent(inputs::add);
        }
        return inputs;
    }

    Optional<InputData> getSourceNodeInputData(Edge<?, ?> edge) {
        DRGElement drgElement;
        View view;
        org.kie.workbench.common.stunner.core.graph.Node sourceNode = edge.getSourceNode();
        if (sourceNode.getContent() instanceof View && (view = (View)sourceNode.getContent()).getDefinition() instanceof DRGElement && (drgElement = (DRGElement)view.getDefinition()) instanceof InputData) {
            return Optional.of((InputData)drgElement);
        }
        return Optional.empty();
    }

    boolean isOutputDecision(View<?> childView, View<DecisionService> decisionServiceView) {
        double decisionServiceViewLineY;
        double childViewY = childView.getBounds().getUpperLeft().getY();
        return childViewY < (decisionServiceViewLineY = ((DecisionService)decisionServiceView.getDefinition()).getDividerLineY().getValue().doubleValue());
    }

    org.kie.workbench.common.stunner.core.graph.Node getElementWithContentId(String contentDefinitionId, Stream<org.kie.workbench.common.stunner.core.graph.Node> stream) {
        return stream.filter(node -> this.definitionContainsDRGElement((org.kie.workbench.common.stunner.core.graph.Node)node) && Objects.equals(this.getDRGElementFromContentDefinition((org.kie.workbench.common.stunner.core.graph.Node)node).getContentDefinitionId(), contentDefinitionId)).findFirst().orElseThrow(() -> new IllegalStateException("Decision Service for contentDefinitionId '" + contentDefinitionId + "' not found."));
    }

    private boolean definitionContainsDRGElement(org.kie.workbench.common.stunner.core.graph.Node node) {
        return node.getContent() instanceof Definition && ((Definition)node.getContent()).getDefinition() instanceof DRGElement;
    }

    private DRGElement getDRGElementFromContentDefinition(org.kie.workbench.common.stunner.core.graph.Node node) {
        return (DRGElement)((Definition)node.getContent()).getDefinition();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<DecisionServiceParametersList> valueChangeHandler) {
        return this.addHandler((EventHandler)valueChangeHandler, ValueChangeEvent.getType());
    }
}

