/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.common.HasTypeRefHelper;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.expressions.util.NameUtils;
import org.kie.workbench.common.dmn.client.editors.types.HasValueAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.NameAndDataTypeColumnRenderer;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNSimpleGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;

public abstract class EditableNameAndDataTypeColumn<G extends BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>
extends DMNSimpleGridColumn<G, InformationItemCell.HasNameCell> {
    protected final Predicate<Integer> isEditable;
    protected final Consumer<HasName> clearValueConsumer;
    protected final BiConsumer<HasName, Name> setValueConsumer;
    protected final BiConsumer<HasTypeRef, QName> setTypeRefConsumer;
    protected final TranslationService translationService;
    protected final CellEditorControlsView.Presenter cellEditorControls;
    protected final ValueAndDataTypePopoverView.Presenter editor;

    public EditableNameAndDataTypeColumn(GridColumn.HeaderMetaData headerMetaData, double width, G gridWidget, Predicate<Integer> isEditable, Consumer<HasName> clearValueConsumer, BiConsumer<HasName, Name> setValueConsumer, BiConsumer<HasTypeRef, QName> setTypeRefConsumer, TranslationService translationService, CellEditorControlsView.Presenter cellEditorControls, ValueAndDataTypePopoverView.Presenter editor) {
        this(Collections.singletonList(headerMetaData), width, gridWidget, isEditable, clearValueConsumer, setValueConsumer, setTypeRefConsumer, translationService, cellEditorControls, editor);
    }

    public EditableNameAndDataTypeColumn(List<GridColumn.HeaderMetaData> headerMetaData, double width, G gridWidget, Predicate<Integer> isEditable, Consumer<HasName> clearValueConsumer, BiConsumer<HasName, Name> setValueConsumer, BiConsumer<HasTypeRef, QName> setTypeRefConsumer, TranslationService translationService, CellEditorControlsView.Presenter cellEditorControls, ValueAndDataTypePopoverView.Presenter editor) {
        super(headerMetaData, new NameAndDataTypeColumnRenderer(), width, gridWidget);
        this.isEditable = isEditable;
        this.clearValueConsumer = clearValueConsumer;
        this.setValueConsumer = setValueConsumer;
        this.setTypeRefConsumer = setTypeRefConsumer;
        this.translationService = translationService;
        this.cellEditorControls = cellEditorControls;
        this.editor = editor;
        this.setMovable(false);
        this.setResizable(true);
    }

    protected abstract String getPopoverTitle();

    public void edit(GridCell<InformationItemCell.HasNameCell> cell, GridBodyCellRenderContext context, Consumer<GridCellValue<InformationItemCell.HasNameCell>> callback) {
        int rowIndex = context.getRowIndex();
        if (!this.isEditable.test(rowIndex)) {
            return;
        }
        int uiRowIndex = context.getRowIndex();
        int uiColumnIndex = context.getColumnIndex();
        double cellWidth = context.getCellWidth();
        double cellHeight = context.getCellHeight();
        double absoluteCellX = context.getAbsoluteCellX();
        double absoluteCellY = context.getAbsoluteCellY();
        final InformationItemCell.HasNameAndDataTypeCell binding = (InformationItemCell.HasNameAndDataTypeCell)cell.getValue().getValue();
        this.editor.bind(new HasValueAndTypeRef<Name>(){

            public QName getTypeRef() {
                return binding.getTypeRef();
            }

            public void setTypeRef(QName typeRef) {
                if (Objects.equals(typeRef, this.getTypeRef())) {
                    return;
                }
                EditableNameAndDataTypeColumn.this.setTypeRefConsumer.accept(binding, typeRef);
            }

            public Name getValue() {
                return binding.getName();
            }

            public void setValue(Name name) {
                if (Objects.equals(name, this.getValue())) {
                    return;
                }
                if (name == null || name.getValue() == null || name.getValue().trim().isEmpty()) {
                    EditableNameAndDataTypeColumn.this.clearValueConsumer.accept(binding);
                } else {
                    EditableNameAndDataTypeColumn.this.setValueConsumer.accept(binding, name);
                }
            }

            @Override
            public String getPopoverTitle() {
                return EditableNameAndDataTypeColumn.this.getPopoverTitle();
            }

            @Override
            public Name toModelValue(String componentValue) {
                return new Name(componentValue);
            }

            @Override
            public String toWidgetValue(Name modelValue) {
                return modelValue.getValue();
            }

            @Override
            public String getValueLabel() {
                return EditableNameAndDataTypeColumn.this.translationService.getTranslation("NameAndDataTypePopover.NameLabel");
            }

            @Override
            public String normaliseValue(String componentValue) {
                return NameUtils.normaliseName(componentValue);
            }

            public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
                return binding.asDMNModelInstrumentedBase();
            }

            public List<HasTypeRef> getHasTypeRefs() {
                return HasTypeRefHelper.getNotNullHasTypeRefs((HasTypeRef)binding);
            }
        }, uiRowIndex, uiColumnIndex);
        double[] dxy = new double[]{absoluteCellX + cellWidth / 2.0, absoluteCellY + cellHeight / 2.0};
        Optional rx = ((GridBodyCellEditContext)context).getRelativeLocation();
        rx.ifPresent(r -> {
            dxy[0] = r.getX();
            dxy[1] = r.getY();
        });
        this.cellEditorControls.show(this.editor, (int)dxy[0], (int)dxy[1]);
    }

    @Override
    protected GridCellValue<InformationItemCell.HasNameCell> makeDefaultCellValue() {
        return new BaseGridCellValue((Object)InformationItemCell.HasNameCell.wrap(""));
    }

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        this.updateWidthOfPeers();
    }
}

