/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.shape.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasValue;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.util.RendererUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.util.TypeRefUtils;
import org.kie.workbench.common.dmn.client.editors.types.HasValueAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditablePopupHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;

public abstract class ValueAndDataTypeHeaderMetaData<V, HV extends HasValue<V>>
extends EditablePopupHeaderMetaData<HasValueAndTypeRef, ValueAndDataTypePopoverView.Presenter>
implements HasValueAndTypeRef<V> {
    protected final Optional<HV> hasValue;
    protected final Supplier<HasTypeRef> hasTypeRef;
    protected final Consumer<HV> clearValueConsumer;
    protected final BiConsumer<HV, V> setValueConsumer;
    protected final BiConsumer<HasTypeRef, QName> setTypeRefConsumer;
    protected final TranslationService translationService;

    public ValueAndDataTypeHeaderMetaData(HasExpression hasExpression, Optional<HV> hasValue, Consumer<HV> clearValueConsumer, BiConsumer<HV, V> setValueConsumer, BiConsumer<HasTypeRef, QName> setTypeRefConsumer, TranslationService translationService, CellEditorControlsView.Presenter cellEditorControls, ValueAndDataTypePopoverView.Presenter editor) {
        this(hasValue, () -> TypeRefUtils.getTypeRefOfExpression(hasExpression.getExpression(), hasExpression), clearValueConsumer, setValueConsumer, setTypeRefConsumer, translationService, cellEditorControls, editor);
    }

    public ValueAndDataTypeHeaderMetaData(Optional<HV> hasValue, Supplier<HasTypeRef> hasTypeRef, Consumer<HV> clearValueConsumer, BiConsumer<HV, V> setValueConsumer, BiConsumer<HasTypeRef, QName> setTypeRefConsumer, TranslationService translationService, CellEditorControlsView.Presenter cellEditorControls, ValueAndDataTypePopoverView.Presenter editor) {
        super(cellEditorControls, editor);
        this.hasValue = hasValue;
        this.hasTypeRef = hasTypeRef;
        this.clearValueConsumer = clearValueConsumer;
        this.setValueConsumer = setValueConsumer;
        this.setTypeRefConsumer = setTypeRefConsumer;
        this.translationService = translationService;
    }

    @Override
    protected HasValueAndTypeRef getPresenter() {
        return this;
    }

    public String getTitle() {
        return this.toWidgetValue(this.getValue());
    }

    public void setValue(V name) {
        this.hasValue.ifPresent(hn -> {
            if (Objects.equals(name, this.getValue())) {
                return;
            }
            if (this.isEmptyValue(name)) {
                this.clearValueConsumer.accept(hn);
            } else {
                this.setValueConsumer.accept(hn, name);
            }
        });
    }

    protected abstract boolean isEmptyValue(V var1);

    public QName getTypeRef() {
        return this.hasTypeRef.get().getTypeRef();
    }

    public void setTypeRef(QName typeRef) {
        if (Objects.equals(typeRef, this.getTypeRef())) {
            return;
        }
        this.setTypeRefConsumer.accept(this.hasTypeRef.get(), typeRef);
    }

    @Override
    public Group render(GridHeaderColumnRenderContext context, double blockWidth, double blockHeight) {
        return RendererUtils.getValueAndDataTypeHeaderText(this, context, blockWidth, blockHeight);
    }

    public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
        return this.hasTypeRef.get().asDMNModelInstrumentedBase();
    }

    public List<HasTypeRef> getHasTypeRefs() {
        return new ArrayList<HasTypeRef>(Collections.singletonList(this));
    }
}

