/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.handlers;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.DefaultGridWidgetCellSelectorMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;

public class DelegatingGridWidgetCellSelectorMouseEventHandler
extends DefaultGridWidgetCellSelectorMouseEventHandler {
    private final Supplier<GridCellTuple> parentSupplier;
    private final Supplier<Integer> nestingSupplier;

    public DelegatingGridWidgetCellSelectorMouseEventHandler(GridSelectionManager selectionManager, Supplier<GridCellTuple> parentSupplier, Supplier<Integer> nestingSupplier) {
        super(selectionManager);
        this.parentSupplier = parentSupplier;
        this.nestingSupplier = nestingSupplier;
    }

    public boolean onNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        GridWidget parentGridWidget;
        if (this.nestingSupplier.get() == 0) {
            return this.doSuperOnNodeMouseEvent(gridWidget, relativeLocation, uiHeaderRowIndex, uiHeaderColumnIndex, uiRowIndex, uiColumnIndex, event);
        }
        boolean isHandled = false;
        if (uiRowIndex.isPresent() && uiColumnIndex.isPresent()) {
            isHandled = this.delegatedHandleBodyCell(gridWidget, uiRowIndex.get(), uiColumnIndex.get(), event);
        }
        if (isHandled && !(parentGridWidget = this.parentSupplier.get().getGridWidget()).isSelected()) {
            this.selectionManager.select(parentGridWidget);
        }
        return isHandled;
    }

    boolean doSuperOnNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        return super.onNodeMouseEvent(gridWidget, relativeLocation, uiHeaderRowIndex, uiHeaderColumnIndex, uiRowIndex, uiColumnIndex, event);
    }

    private boolean delegatedHandleBodyCell(GridWidget gridWidget, int uiRowIndex, int uiColumnIndex, AbstractNodeMouseEvent event) {
        GridCellTuple parent = this.parentSupplier.get();
        GridWidget parentGridWidget = parent.getGridWidget();
        int parentRowIndex = parent.getRowIndex();
        int parentColumnIndex = parent.getColumnIndex();
        boolean isSelectionChanged = parentGridWidget.getCellSelectionManager().selectCell(parentRowIndex, parentColumnIndex, event.isShiftKeyDown(), event.isControlKeyDown());
        if (isSelectionChanged) {
            parentGridWidget.getLayer().batch();
        }
        if (gridWidget instanceof BaseExpressionGrid) {
            ((BaseExpressionGrid)gridWidget).doAfterSelectionChange(uiRowIndex, uiColumnIndex);
        }
        return isSelectionChanged;
    }
}

