/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import java.util.Objects;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridCell;
import org.kie.workbench.common.dmn.client.widgets.grid.model.HasDynamicHeight;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;

public abstract class BaseHasDynamicHeightCell<T>
extends DMNGridCell<T>
implements HasDynamicHeight {
    public static final double DEFAULT_HEIGHT = 48.0;
    protected final double lineHeight;
    private double height;

    public BaseHasDynamicHeightCell(GridCellValue<T> value, double lineHeight) {
        super(value);
        this.lineHeight = lineHeight;
        this.height = this.getExpressionTextHeight();
    }

    protected void setValue(GridCellValue<T> value) {
        super.setValue(value);
        this.height = this.getExpressionTextHeight();
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    protected double getExpressionTextHeight() {
        if (Objects.isNull(this.value) || Objects.isNull(this.value.getValue())) {
            return 48.0;
        }
        String asText = this.getValue().getValue().toString();
        if (StringUtils.isEmpty((String)asText)) {
            return 48.0;
        }
        int expressionLineCount = asText.split("\\r?\\n", -1).length;
        return (double)expressionLineCount * this.lineHeight + 15.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseHasDynamicHeightCell)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseHasDynamicHeightCell that = (BaseHasDynamicHeightCell)o;
        return Double.compare(that.lineHeight, this.lineHeight) == 0 && Double.compare(that.height, this.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lineHeight, this.height);
    }
}

