/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.builder;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.IsInformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.canvas.controls.builder.ObserverBuilderControl;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ObserverBuilderControlTest {
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private ObserverBuilderControl observerBuilderControl;

    @Before
    public void setup() {
        ((ObserverBuilderControl)Mockito.doCallRealMethod().when((Object)this.observerBuilderControl)).updateElementFromDefinition((Element)ArgumentMatchers.anyObject(), ArgumentMatchers.anyObject());
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentDMNDiagramElement()).thenReturn(Optional.empty());
        Mockito.when((Object)this.observerBuilderControl.getDMNDiagramsSession()).thenReturn((Object)this.dmnDiagramsSession);
    }

    @Test
    public void testUpdateNameFromDefinition() {
        String expectedName = "expectedName";
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        HasName newDefinition = (HasName)Mockito.mock(HasName.class);
        Name newDefinitionName = (Name)Mockito.mock(Name.class);
        HasName definition = (HasName)Mockito.mock(HasName.class);
        Name definitionName = (Name)Mockito.mock(Name.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newDefinition);
        Mockito.when((Object)newDefinition.getName()).thenReturn((Object)newDefinitionName);
        Mockito.when((Object)definition.getName()).thenReturn((Object)definitionName);
        Mockito.when((Object)definitionName.getValue()).thenReturn((Object)"expectedName");
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)definition);
        ((Name)Mockito.verify((Object)newDefinitionName)).setValue("expectedName");
    }

    @Test
    public void testUpdateDynamicReadOnlyTrueFromDefinition() {
        this.testUpdateDynamicReadOnlyFromDefinition(true);
    }

    @Test
    public void testUpdateDynamicReadOnlyFalseFromDefinition() {
        this.testUpdateDynamicReadOnlyFromDefinition(false);
    }

    private void testUpdateDynamicReadOnlyFromDefinition(boolean expectedDynamicReadOnlyValue) {
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        DynamicReadOnly newDefinition = (DynamicReadOnly)Mockito.mock(DynamicReadOnly.class);
        DynamicReadOnly definition = (DynamicReadOnly)Mockito.mock(DynamicReadOnly.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newDefinition);
        Mockito.when((Object)definition.isAllowOnlyVisualChange()).thenReturn((Object)expectedDynamicReadOnlyValue);
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)definition);
        ((DynamicReadOnly)Mockito.verify((Object)newDefinition)).setAllowOnlyVisualChange(expectedDynamicReadOnlyValue);
    }

    @Test
    public void testUpdateIdFromDefinition() {
        String expectedId = "happyId";
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        DMNElement newDefinition = (DMNElement)Mockito.mock(DMNElement.class);
        Id newDefinitionId = (Id)Mockito.mock(Id.class);
        DMNElement definition = (DMNElement)Mockito.mock(DMNElement.class);
        Id definitionId = (Id)Mockito.mock(Id.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newDefinition);
        Mockito.when((Object)newDefinition.getId()).thenReturn((Object)newDefinitionId);
        Mockito.when((Object)definition.getId()).thenReturn((Object)definitionId);
        Mockito.when((Object)definitionId.getValue()).thenReturn((Object)"happyId");
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)definition);
        ((Id)Mockito.verify((Object)newDefinitionId)).setValue("happyId");
    }

    @Test
    public void testUpdateExpressionFromDefinition() {
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        HasExpression newHasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        Expression expression = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newHasExpression);
        Mockito.when((Object)hasExpression.getExpression()).thenReturn((Object)expression);
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)hasExpression);
        ((HasExpression)Mockito.verify((Object)newHasExpression)).setExpression(expression);
    }

    @Test
    public void testUpdateEncapsulatedLogicFromDefinition() {
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        BusinessKnowledgeModel newBusinessKnowledgeModel = (BusinessKnowledgeModel)Mockito.mock(BusinessKnowledgeModel.class);
        BusinessKnowledgeModel businessKnowledgeModel = (BusinessKnowledgeModel)Mockito.mock(BusinessKnowledgeModel.class);
        FunctionDefinition functionDefinition = (FunctionDefinition)Mockito.mock(FunctionDefinition.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newBusinessKnowledgeModel);
        Mockito.when((Object)businessKnowledgeModel.getEncapsulatedLogic()).thenReturn((Object)functionDefinition);
        Mockito.when((Object)newBusinessKnowledgeModel.getName()).thenReturn((Object)new Name());
        Mockito.when((Object)businessKnowledgeModel.getName()).thenReturn((Object)new Name());
        Mockito.when((Object)newBusinessKnowledgeModel.getId()).thenReturn((Object)new Id());
        Mockito.when((Object)businessKnowledgeModel.getId()).thenReturn((Object)new Id());
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)businessKnowledgeModel);
        ((BusinessKnowledgeModel)Mockito.verify((Object)newBusinessKnowledgeModel)).setEncapsulatedLogic(functionDefinition);
    }

    @Test
    public void testUpdateVariableFromDefinition() {
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        HasVariable newHasVariable = (HasVariable)Mockito.mock(HasVariable.class);
        HasVariable hasVariable = (HasVariable)Mockito.mock(HasVariable.class);
        IsInformationItem isInformationItem = (IsInformationItem)Mockito.mock(IsInformationItem.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newHasVariable);
        Mockito.when((Object)hasVariable.getVariable()).thenReturn((Object)isInformationItem);
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)hasVariable);
        ((HasVariable)Mockito.verify((Object)newHasVariable)).setVariable(isInformationItem);
    }

    @Test
    public void testUpdateDMNDiagramIdFromSelectedDMNDiagram() {
        DRGElement newDefinition = (DRGElement)Mockito.mock(DRGElement.class);
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        Object definition = Mockito.mock(Object.class);
        String selectedDiagramId = "selected diagram id";
        DMNDiagramElement selectedDiagram = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Id id = (Id)Mockito.mock(Id.class);
        Mockito.when((Object)id.getValue()).thenReturn((Object)"selected diagram id");
        Mockito.when((Object)selectedDiagram.getId()).thenReturn((Object)id);
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentDMNDiagramElement()).thenReturn(Optional.of(selectedDiagram));
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newDefinition);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        this.observerBuilderControl.updateElementFromDefinition(element, definition);
        ((DRGElement)Mockito.verify((Object)newDefinition)).setDiagramId("selected diagram id");
    }
}

