/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNFlowActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.ManagedInstanceStub;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateConnectorToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateNodeToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxDomainLookups;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.lookup.domain.CommonDomainLookups;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DMNFlowActionsToolboxFactoryTest {
    private static final String DS_ID = "defSetId1";
    private static final String EDGE_ID = "edgeDefId1";
    private static final String NODE_ID = "nodeDefId1";
    private static final String E_UUID = "e1";
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private AdapterManager adapters;
    @Mock
    private DefinitionAdapter definitionAdapter;
    @Mock
    private ToolboxDomainLookups toolboxLookups;
    @Mock
    private CommonDomainLookups domainLookups;
    @Mock
    private CreateConnectorToolboxAction createConnectorActionInstance;
    private ManagedInstanceStub<CreateConnectorToolboxAction> createConnectorAction;
    @Mock
    private CreateNodeToolboxAction createNodeActionInstance;
    private ManagedInstanceStub<CreateNodeToolboxAction> createNodeAction;
    @Mock
    private ActionsToolboxView viewInstance;
    private ManagedInstanceStub<ActionsToolboxView> view;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    @Mock
    private Graph graph;
    @Mock
    private Object allowedNodeDefinition;
    @Mock
    private Node<View<Object>, Edge> element;
    private DMNFlowActionsToolboxFactory tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.definitionManager.adapters()).thenReturn((Object)this.adapters);
        Mockito.when((Object)this.adapters.forDefinition()).thenReturn((Object)this.definitionAdapter);
        Mockito.when((Object)this.definitionAdapter.getId(ArgumentMatchers.eq((Object)this.allowedNodeDefinition))).thenReturn((Object)DefinitionId.build((String)NODE_ID));
        this.createConnectorAction = new ManagedInstanceStub((Object[])new CreateConnectorToolboxAction[]{this.createConnectorActionInstance});
        Mockito.when((Object)this.createConnectorActionInstance.setEdgeId((String)Mockito.any())).thenReturn((Object)this.createConnectorActionInstance);
        this.createNodeAction = new ManagedInstanceStub((Object[])new CreateNodeToolboxAction[]{this.createNodeActionInstance});
        Mockito.when((Object)this.createNodeActionInstance.setEdgeId((String)Mockito.any())).thenReturn((Object)this.createNodeActionInstance);
        Mockito.when((Object)this.createNodeActionInstance.setNodeId((String)Mockito.any())).thenReturn((Object)this.createNodeActionInstance);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getDefinitionSetId()).thenReturn((Object)DS_ID);
        Mockito.when((Object)this.element.getUUID()).thenReturn((Object)E_UUID);
        Mockito.when((Object)this.element.asNode()).thenReturn(this.element);
        Mockito.when((Object)this.toolboxLookups.get((String)Mockito.any())).thenReturn((Object)this.domainLookups);
        Mockito.when((Object)this.domainLookups.lookupTargetConnectors((Node)ArgumentMatchers.eq(this.element))).thenReturn(Collections.singleton(EDGE_ID));
        Mockito.when((Object)this.domainLookups.lookupTargetNodes((Graph)ArgumentMatchers.eq((Object)this.graph), (Node)ArgumentMatchers.eq(this.element), (String)ArgumentMatchers.eq((Object)EDGE_ID))).thenReturn(Collections.singleton(NODE_ID));
        this.view = new ManagedInstanceStub((Object[])new ActionsToolboxView[]{this.viewInstance});
        this.tested = new DMNFlowActionsToolboxFactory(this.toolboxLookups, this.createConnectorAction, this.createNodeAction, this.view);
    }

    @Test
    public void testBuildToolbox() {
        Optional toolbox = this.tested.build(this.canvasHandler, this.element);
        Assert.assertTrue((boolean)toolbox.isPresent());
        Assert.assertTrue((boolean)(toolbox.get() instanceof ActionsToolbox));
        ActionsToolbox actionsToolbox = (ActionsToolbox)toolbox.get();
        Assert.assertEquals((Object)E_UUID, (Object)actionsToolbox.getElementUUID());
        Assert.assertEquals((long)2L, (long)actionsToolbox.size());
        Iterator actionIt = actionsToolbox.iterator();
        Assert.assertEquals((Object)this.createConnectorActionInstance, actionIt.next());
        Assert.assertEquals((Object)this.createNodeActionInstance, actionIt.next());
        ((CreateConnectorToolboxAction)Mockito.verify((Object)this.createConnectorActionInstance, (VerificationMode)Mockito.times((int)1))).setEdgeId((String)ArgumentMatchers.eq((Object)EDGE_ID));
        ((CreateNodeToolboxAction)Mockito.verify((Object)this.createNodeActionInstance, (VerificationMode)Mockito.times((int)1))).setEdgeId((String)ArgumentMatchers.eq((Object)EDGE_ID));
        ((CreateNodeToolboxAction)Mockito.verify((Object)this.createNodeActionInstance, (VerificationMode)Mockito.times((int)1))).setNodeId((String)ArgumentMatchers.eq((Object)NODE_ID));
        ((ActionsToolboxView)Mockito.verify((Object)this.viewInstance, (VerificationMode)Mockito.times((int)1))).init((ActionsToolbox)ArgumentMatchers.eq((Object)actionsToolbox));
    }
}

